/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.app.controller;

import com.gaotao.common.utils.R;
import com.gaotao.common.validator.ValidatorUtils;
import com.gaotao.modules.app.form.LoginForm;
import com.gaotao.modules.app.service.UserService;
import com.gaotao.modules.app.utils.JwtUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class AppLoginController {
    @Autowired
    private UserService userService;
    @Autowired
    private JwtUtils jwtUtils;

    @PostMapping(value={"login"})
    public R login(@RequestBody LoginForm form) {
        ValidatorUtils.validateEntity(form, new Class[0]);
        long userId = this.userService.login(form);
        String token = this.jwtUtils.generateToken(userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token", token);
        map.put("expire", this.jwtUtils.getExpire());
        return R.ok(map);
    }
}

