/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.common.aspect;

import com.gaotao.common.exception.XJException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class RedisAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${spring.redis.open: true}")
    private boolean open;

    @Around(value="execution(* com.gaotao.common.utils.RedisUtils.*(..))")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        if (this.open) {
            try {
                result = point.proceed();
            }
            catch (Exception e) {
                this.logger.error("redis error", (Throwable)e);
                throw new XJException("Redis\u670d\u52a1\u5f02\u5e38");
            }
        }
        return result;
    }
}

