/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.RowType;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import java.util.logging.Level;

final class ScrollWindow {
    private TDSReaderMark[] rowMark;
    private boolean[] updatedRow;
    private boolean[] deletedRow;
    private RowType[] rowType;
    private int size = 0;
    private int maxRows = 0;
    private int currentRow;

    final int getMaxRows() {
        return this.maxRows;
    }

    final int getRow() {
        return this.currentRow;
    }

    ScrollWindow(int n) {
        this.setSize(n);
        this.reset();
    }

    private final void setSize(int n) {
        assert (this.size != n);
        this.size = n;
        this.maxRows = n;
        this.rowMark = new TDSReaderMark[n];
        this.updatedRow = new boolean[n];
        this.deletedRow = new boolean[n];
        this.rowType = new RowType[n];
        for (int i = 0; i < n; ++i) {
            this.rowType[i] = RowType.UNKNOWN;
        }
    }

    final void clear() {
        for (int i = 0; i < this.rowMark.length; ++i) {
            this.rowMark[i] = null;
            this.updatedRow[i] = false;
            this.deletedRow[i] = false;
            this.rowType[i] = RowType.UNKNOWN;
        }
        assert (this.size > 0);
        this.maxRows = this.size;
        this.reset();
    }

    final void reset() {
        this.currentRow = 0;
    }

    final void resize(int n) {
        assert (n > 0);
        if (n != this.size) {
            this.setSize(n);
        }
    }

    final String logCursorState() {
        return " currentRow:" + this.currentRow + " maxRows:" + this.maxRows;
    }

    final boolean next(SQLServerResultSet sQLServerResultSet) throws SQLServerException {
        if (SQLServerResultSet.logger.isLoggable(Level.FINER)) {
            SQLServerResultSet.logger.finer(sQLServerResultSet.toString() + this.logCursorState());
        }
        assert (0 <= this.currentRow && this.currentRow <= this.maxRows + 1);
        if (this.maxRows + 1 == this.currentRow) {
            return false;
        }
        if (this.currentRow >= 1) {
            this.updatedRow[this.currentRow - 1] = sQLServerResultSet.getUpdatedCurrentRow();
            this.deletedRow[this.currentRow - 1] = sQLServerResultSet.getDeletedCurrentRow();
            this.rowType[this.currentRow - 1] = sQLServerResultSet.getCurrentRowType();
        }
        ++this.currentRow;
        if (this.maxRows + 1 == this.currentRow) {
            sQLServerResultSet.fetchBufferNext();
            return false;
        }
        if (null != this.rowMark[this.currentRow - 1]) {
            sQLServerResultSet.fetchBufferReset(this.rowMark[this.currentRow - 1]);
            sQLServerResultSet.setCurrentRowType(this.rowType[this.currentRow - 1]);
            sQLServerResultSet.setUpdatedCurrentRow(this.updatedRow[this.currentRow - 1]);
            sQLServerResultSet.setDeletedCurrentRow(this.deletedRow[this.currentRow - 1]);
            return true;
        }
        if (sQLServerResultSet.fetchBufferNext()) {
            this.rowMark[this.currentRow - 1] = sQLServerResultSet.fetchBufferMark();
            this.rowType[this.currentRow - 1] = sQLServerResultSet.getCurrentRowType();
            if (SQLServerResultSet.logger.isLoggable(Level.FINEST)) {
                SQLServerResultSet.logger.finest(sQLServerResultSet.toString() + " Set mark " + this.rowMark[this.currentRow - 1] + " for row " + this.currentRow + " of type " + (Object)((Object)this.rowType[this.currentRow - 1]));
            }
            return true;
        }
        this.maxRows = this.currentRow - 1;
        return false;
    }

    final void previous(SQLServerResultSet sQLServerResultSet) throws SQLServerException {
        if (SQLServerResultSet.logger.isLoggable(Level.FINER)) {
            SQLServerResultSet.logger.finer(sQLServerResultSet.toString() + this.logCursorState());
        }
        assert (0 <= this.currentRow && this.currentRow <= this.maxRows + 1);
        if (0 == this.currentRow) {
            return;
        }
        if (this.currentRow <= this.maxRows) {
            assert (this.currentRow >= 1);
            this.updatedRow[this.currentRow - 1] = sQLServerResultSet.getUpdatedCurrentRow();
            this.deletedRow[this.currentRow - 1] = sQLServerResultSet.getDeletedCurrentRow();
            this.rowType[this.currentRow - 1] = sQLServerResultSet.getCurrentRowType();
        }
        --this.currentRow;
        if (0 == this.currentRow) {
            return;
        }
        assert (null != this.rowMark[this.currentRow - 1]);
        sQLServerResultSet.fetchBufferReset(this.rowMark[this.currentRow - 1]);
        sQLServerResultSet.setCurrentRowType(this.rowType[this.currentRow - 1]);
        sQLServerResultSet.setUpdatedCurrentRow(this.updatedRow[this.currentRow - 1]);
        sQLServerResultSet.setDeletedCurrentRow(this.deletedRow[this.currentRow - 1]);
    }
}

