/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.controller;

import com.gaotao.common.annotation.SysLog;
import com.gaotao.common.utils.PageUtils;
import com.gaotao.common.utils.R;
import com.gaotao.common.validator.Assert;
import com.gaotao.common.validator.ValidatorUtils;
import com.gaotao.common.validator.group.AddGroup;
import com.gaotao.common.validator.group.UpdateGroup;
import com.gaotao.modules.sys.controller.AbstractController;
import com.gaotao.modules.sys.entity.SysUserEntity;
import com.gaotao.modules.sys.form.PasswordForm;
import com.gaotao.modules.sys.service.SysUserRoleService;
import com.gaotao.modules.sys.service.SysUserService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/user"})
public class SysUserController
extends AbstractController {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserRoleService sysUserRoleService;

    @GetMapping(value={"/list"})
    public R list(@RequestParam Map<String, Object> params) {
        if (this.getUserId() != 1L) {
            params.put("createUserId", this.getUserId());
        }
        PageUtils page = this.sysUserService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @PostMapping(value={"/userList"})
    public R userList(@RequestBody SysUserEntity params) {
        List<SysUserEntity> list = this.sysUserService.userList(params);
        return R.ok().put("list", (Object)list);
    }

    @GetMapping(value={"/info"})
    public R info() {
        return R.ok().put("user", (Object)this.getUser());
    }

    @PostMapping(value={"updateUserLanguageDefault"})
    public R updateUserLanguageDefault(SysUserEntity userEntity) {
        this.sysUserService.updateUserLanguageDefault(userEntity);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @SysLog(value="\u4fee\u6539\u5bc6\u7801")
    @PostMapping(value={"/password"})
    public R password(@RequestBody PasswordForm form) {
        Assert.isBlank(form.getNewPassword(), this.getLanguageMsg("200611"));
        String password = new Sha256Hash((Object)form.getPassword(), (Object)this.getUser().getSalt()).toHex();
        String newPassword = new Sha256Hash((Object)form.getNewPassword(), (Object)this.getUser().getSalt()).toHex();
        boolean flag = this.sysUserService.updatePassword(this.getUserId(), password, newPassword);
        if (!flag) {
            return R.error(this.getLanguageMsg("200216"));
        }
        return R.ok(this.getLanguageMsg("200000"));
    }

    @GetMapping(value={"/info/{userId}"})
    public R info(@PathVariable(value="userId") Long userId) {
        SysUserEntity user = (SysUserEntity)this.sysUserService.getById(userId);
        List<Long> roleIdList = this.sysUserRoleService.queryRoleIdList(userId);
        user.setRoleIdList(roleIdList);
        return R.ok().put("user", (Object)user);
    }

    @SysLog(value="\u4fdd\u5b58\u7528\u6237")
    @PostMapping(value={"/save"})
    public R save(@RequestBody SysUserEntity user) {
        ValidatorUtils.validateEntity(user, AddGroup.class);
        user.setCreateUserId(this.getUserId());
        this.sysUserService.saveUser(user);
        return R.ok();
    }

    @SysLog(value="\u4fee\u6539\u7528\u6237")
    @PostMapping(value={"/update"})
    public R update(@RequestBody SysUserEntity user) {
        ValidatorUtils.validateEntity(user, UpdateGroup.class);
        user.setCreateUserId(this.getUserId());
        this.sysUserService.update(user);
        return R.ok();
    }

    @SysLog(value="\u5220\u9664\u7528\u6237")
    @PostMapping(value={"/delete"})
    public R delete(@RequestBody Long[] userIds) {
        if (ArrayUtils.contains((Object[])userIds, (Object)1L)) {
            return R.error(this.getLanguageMsg("200217"));
        }
        if (ArrayUtils.contains((Object[])userIds, (Object)this.getUserId())) {
            return R.error(this.getLanguageMsg("200218"));
        }
        this.sysUserService.deleteBatch(userIds);
        return R.ok();
    }

    @PostMapping(value={"updateUserLanguage"})
    public R updateUserLanguage(@RequestBody SysUserEntity user) {
        user.setUserId(this.getUserId());
        this.sysUserService.updateUserLanguageDefault(user);
        return R.ok();
    }

    @PostMapping(value={"updateUserStatus"})
    public R updateUserStatus(@RequestBody SysUserEntity user) {
        SysUserEntity user1 = this.getUser();
        System.out.println(user1);
        this.sysUserService.update(user);
        return R.ok();
    }
}

