var rollList = []

// 获取物料名称
function getPartName(partNo) {
    let part = {"partno": partNo}
    $.ajax({
        url: "/part/getPart",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(part),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.data) {
                var partName = data.data.partDesc;
                var orderNo = data.data.orderNo;
                $("#partName").val(partName)
              //  $("#partNo").val("")
                $("#storageNumber").val("")
                $("#rollNumber").val("")
                $("#display").val("")
                $("#orderRef1").val(orderNo)
                $("#orderRef2").val("")
                $("#rollNo").val("")
            } else {
                $("#partName").val('')
                $("#partNo").val("")
                $("#storageNumber").val("")
                $("#rollNumber").val("")
                $("#display").val("")
                $("#orderRef1").val("")
                $("#orderRef2").val("")
                layer.alert('该物料不存在');
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
            $("#roll_table").html('')
        },
        error: function (data) {
        }
    });
}

// 更据卷号获取料号
function getPartNo(rollno) {
    var roll = {
        rollno: rollno
    }
    $.ajax({
        url: "/finishedProduct/crollinfo/getPartByRollno",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(roll),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.cRollinfo) {
                $("#partNo").val(data.cRollinfo.partno)
                $("#partName").val(data.cRollinfo.partDescription)
                $("#orderRef1").val(data.cRollinfo.orderref1)
                $("#orderRef2").val(data.cRollinfo.orderref2)

            } else {
                layer.alert('该卷不存在')
                $("#partNo").val('')
                $("#rollNo").val('')
                $("#partName").val('')
                $("#oderRef1").val('')
                $("#oderRef2").val('')
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
            $("#roll_table").html('')
        },
        error: function (data) {
        }
    });
}

//物料号bind 回车事件
$("#partNo").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var partNo = $("#partNo").val();
        if (null == partNo || partNo == "") {
            layer.alert("物料编码不能为空!");
            return false;
        } else {
            getPartName(partNo);
        }
    }
    return true;
});

//卷号 bind 回车事件
$("#rollNo").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var rollNo = $("#rollNo").val();
        if (null == rollNo || rollNo == "") {
            layer.alert("卷号不能为空!");
            return
        } else {
            getPartNo(rollNo);
        }
    }
    return true;
});

//校验仓库编号是否存在
function getWareHouse() {
    var warehouseId = $("#warehouseId").val()
    var warehouse = {
        warehouseid: warehouseId
    }
    $.ajax({
        url: "/warehouse/getWarehouse",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(warehouse),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.data.warehouse) {
                layer.alert("仓库不存在")
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}

// 其他入库提交
function submitToStorage() {
    var partNo = $("#partNo").val().trim();
    var storageNumber = $("#storageNumber").val().trim()
    var rollNumber = $("#rollNumber").val().trim()
    var warehouseId = $("#warehouseId").val().trim()
    var display = $("#display").val().trim()
    var orderref1 = $("#orderRef1").val().trim()
    var orderref2 = $("#orderRef2").val().trim()

    if (partNo.length == 0) {
        layer.alert("物料编号-不能为空")
        return
    }
    if (storageNumber.length == 0 || storageNumber == 0) {
        layer.alert("入库数量-不能为0,或者为空")
        return
    }
    if (rollNumber.length == 0 || rollNumber == 0) {
        layer.alert("单卷数量-不能为0,或者为空")
        return
    }
    if (!warehouseId) {
        layer.alert("仓库编号-不能为空")
        return
    }
    if (orderref1.length == 0) {
        layer.alert("请填写-生产单号")
        return
    }
    if (orderref2.length == 0) {
        layer.alert("请填写-工序号")
        return
    }
    if (display.length == 0) {
        layer.alert("请填写-入库原因")
        return
    }


    let saveRollStorage = {
        partNo: partNo,
        storageNumber: storageNumber,
        rollNumber: rollNumber,
        warehouseId: warehouseId,
        display: display,
        orderref1: orderref1,
        orderref2: orderref2,
    }

    $.ajax({
        url: "/finishedProduct/crollinfo/rollToStorage",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(saveRollStorage),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                $("#partNo").val('');
                $("#rollNo").val('');
                $("#storageNumber").val('')
                $("#rollNumber").val('')
                $("#display").val('')
                $("#partName").val('')
                $("#orderRef1").val('')
                $("#orderRef2").val('')
                layer.alert('入库成功')
                $("#roll_table").html('')
                rollList = data.inRollList
                data.inRollList.forEach((item, index) => {
                    var str = '<tr id = ' + item.line + item.pickingNo + '>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + item.rollno + '</span></th>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + item.rollqty + '</span></th>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<button   onclick="printRoll(\'' + item.rollno + '\')" data-toggle="modal"  style="padding: 3px 10px;">' +
                        '打印标签</button></th>' +
                        '</tr>';
                    $("#roll_table").append(str);
                })
                print(data.inRollList)
            } else {
                layer.alert('入库失败')
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}

// 补打标签
function printRoll(rollno) {
    var rolls = rollList.filter(item => item.rollno == rollno)
    print(rolls);
}

// 打印卷标签
function print(val) {
    var rollPrintList = val
    if (rollPrintList.length <= 0) {
        return;
    }
    $.ajax({
        url: "/finishedProduct/crollinfo/rollPrint",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(rollPrintList),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                layer.alert("打印成功")
                rollPrintList = []
            }
            if (data.code == 500) {
                layer.alert(data.msg)
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}