/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.report.dao.impl;

import com.gaotao.modules.report.dao.ReportDao;
import com.gaotao.modules.report.data.CustomerReportData;
import com.gaotao.modules.report.data.CustomerReportRoleData;
import com.gaotao.modules.report.data.CustomerSearchColumnData;
import com.gaotao.modules.report.data.SearchReportData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ReportDaoImpl
implements ReportDao {
    @Autowired
    private NamedParameterJdbcTemplate parameterJdbcTemplate;

    @Override
    public List<Map<String, Object>> getReportTypeList(String type, String secondType) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT tbd.id, tbd.site, tbd.type, tbd.second_type, tbd.base_data baseData, tbd.base_desc baseDesc,");
        sql.append("tbd.status, tbd.sort_no, tbd.remark");
        sql.append(" FROM tbl_base_data tbd");
        sql.append(" WHERE tbd.type = :type");
        paramMap.put("type", type);
        if (null != secondType && !"".equals(secondType)) {
            sql.append(" AND tbd.second_type = :secondType");
            paramMap.put("secondType", secondType);
        }
        return this.parameterJdbcTemplate.queryForList(sql.toString(), paramMap);
    }

    @Override
    public List<CustomerReportData> getCustomerReportList(String site, String reportType, String reportName) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT crh.id, crh.site, crh.report_id, crh.report_name, crh.report_type, crh.report_sql, crh.report_remark,");
        sql.append("crh.report_status, crh.sort_no, crh.created_by, crh.created_date, crh.updated_by, crh.updated_date");
        sql.append(" FROM customer_report_header crh");
        sql.append(" WHERE crh.site = :site");
        if (!"\u5168\u90e8".equalsIgnoreCase(reportType)) {
            sql.append(" AND crh.report_type = :reportType");
            paramMap.put("reportType", reportType);
        }
        if (null != reportName && !"".equals(reportName)) {
            sql.append(" AND crh.report_name LIKE '%" + reportName + "%'");
        }
        paramMap.put("site", site);
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(CustomerReportData.class));
    }

    @Override
    public void insertCustomerReport(SearchReportData inData) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO customer_report_header(site, report_id, report_name, report_type, report_sql, report_remark, report_status,");
        sql.append(" sort_no, created_by, created_date)");
        sql.append(" VALUES(:site, :reportId, :reportName, :reportType, :reportSql, :reportRemark, :reportStatus,");
        sql.append(" :sortNo, :createdBy, :createdDate)");
        this.parameterJdbcTemplate.update(sql.toString(), (SqlParameterSource)new BeanPropertySqlParameterSource((Object)inData));
    }

    @Override
    public CustomerReportData getCustomerReportByReportId(SearchReportData inData) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT crh.id, crh.site, crh.report_id, crh.report_name, crh.report_type, crh.report_sql, crh.report_remark,");
        sql.append("crh.report_status, crh.sort_no, crh.created_by, crh.created_date, crh.updated_by, crh.updated_date");
        sql.append(" FROM customer_report_header crh");
        sql.append(" WHERE crh.site = :site AND crh.report_id = :reportId");
        List resultList = this.parameterJdbcTemplate.query(sql.toString(), (SqlParameterSource)new BeanPropertySqlParameterSource((Object)inData), (RowMapper)new BeanPropertyRowMapper(CustomerReportData.class));
        if (resultList.size() == 0) {
            return new CustomerReportData();
        }
        return (CustomerReportData)resultList.get(0);
    }

    @Override
    public void updateCustomerReport(SearchReportData inData) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE customer_report_header SET report_name = :reportName, report_type = :reportType, report_sql = :reportSql,");
        sql.append(" updated_by = :updatedBy, updated_date = :updatedDate WHERE report_id = :reportId");
        this.parameterJdbcTemplate.update(sql.toString(), (SqlParameterSource)new BeanPropertySqlParameterSource((Object)inData));
    }

    @Override
    public List<CustomerSearchColumnData> getSearchColumnsByReportId(SearchReportData inData) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT crs.id, crs.site, crs.report_id, crs.column_field, crs.column_name, crs.column_default_value, crs.column_type,");
        sql.append(" crs.column_remark, crs.sort_no, crs.created_by, crs.created_date, crs.updated_by, crs.updated_date");
        sql.append(" FROM customer_report_search_column crs");
        sql.append(" WHERE crs.site = :site AND crs.report_id = :reportId");
        sql.append(" ORDER BY crs.sort_no ASC");
        return this.parameterJdbcTemplate.query(sql.toString(), (SqlParameterSource)new BeanPropertySqlParameterSource((Object)inData), (RowMapper)new BeanPropertyRowMapper(CustomerSearchColumnData.class));
    }

    @Override
    public void batchInsertCustomerReportSearchColumns(List<CustomerSearchColumnData> newColumnList) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO customer_report_search_column(site, report_id, column_field, column_name, column_default_value, column_type,");
        sql.append(" column_remark, sort_no, created_by, created_date)");
        sql.append(" VALUES(:site, :reportId, :columnField, :columnName, :columnDefaultValue, :columnType,");
        sql.append(" :columnRemark, :sortNo, :createdBy, :createdDate)");
        this.parameterJdbcTemplate.batchUpdate(sql.toString(), SqlParameterSourceUtils.createBatch((Object[])newColumnList.toArray()));
    }

    @Override
    public void saveCustomerSearchColumns(List<CustomerSearchColumnData> inDatas) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE customer_report_search_column SET column_name = :columnName, column_default_value = :columnDefaultValue, column_type = :columnType,");
        sql.append(" column_remark = :columnRemark, sort_no = :sortNo, updated_by = :updatedBy, updated_date = :updatedDate");
        sql.append(" WHERE report_id = :reportId AND column_field = :columnField");
        this.parameterJdbcTemplate.batchUpdate(sql.toString(), SqlParameterSourceUtils.createBatch((Object[])inDatas.toArray()));
    }

    @Override
    public List<Map<String, Object>> runCustomerReportSql(String columnSql) {
        HashMap paramMap = new HashMap();
        return this.parameterJdbcTemplate.queryForList(columnSql, paramMap);
    }

    @Override
    public Integer countUsedCustomerReportByReportId(String reportId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT COUNT(id) FROM customer_report_role crr");
        sql.append(" WHERE crr.report_id = :reportId");
        paramMap.put("reportId", reportId);
        return (Integer)this.parameterJdbcTemplate.queryForObject(sql.toString(), paramMap, Integer.class);
    }

    @Override
    public void deleteCustomerReportSearchColumn(String reportId, String columnField) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("DELETE FROM customer_report_search_column WHERE report_id = :reportId");
        if (null != columnField && !"".equals(columnField)) {
            sql.append(" AND column_field = :columnField");
            paramMap.put("columnField", columnField);
        }
        paramMap.put("reportId", reportId);
        this.parameterJdbcTemplate.update(sql.toString(), paramMap);
    }

    @Override
    public void deleteCustomerReportColumnByReportId(String reportId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("DELETE FROM customer_report_column WHERE report_id = :reportId");
        paramMap.put("reportId", reportId);
        this.parameterJdbcTemplate.update(sql.toString(), paramMap);
    }

    @Override
    public void deleteCustomerReportByReportId(String reportId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("DELETE FROM customer_report_header WHERE report_id = :reportId");
        paramMap.put("reportId", reportId);
        this.parameterJdbcTemplate.update(sql.toString(), paramMap);
    }

    @Override
    public List<CustomerReportRoleData> getAuthRoles(String reportId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT crr.site, sr.role_id, sr.role_name, crr.report_id, (CASE WHEN crr.report_id IS NULL THEN 'N' ELSE 'Y' END) checkedFlag");
        sql.append(" FROM sys_role sr");
        sql.append(" LEFT JOIN customer_report_role crr ON crr.role_id = sr.role_id AND crr.report_id = :reportId");
        paramMap.put("reportId", reportId);
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(CustomerReportRoleData.class));
    }

    @Override
    public void deleteCustomerReportRoleByReportId(String reportId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("DELETE FROM customer_report_role WHERE report_id = :reportId");
        paramMap.put("reportId", reportId);
        this.parameterJdbcTemplate.update(sql.toString(), paramMap);
    }

    @Override
    public void batchInsertCustomerReportRoles(List<CustomerReportRoleData> saveAuthRoles) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO customer_report_role(site, role_id, report_id, created_by, created_date)");
        sql.append(" VALUES(:site, :roleId, :reportId, :createdBy, :createdDate)");
        this.parameterJdbcTemplate.batchUpdate(sql.toString(), SqlParameterSourceUtils.createBatch((Object[])saveAuthRoles.toArray()));
    }

    @Override
    public List<CustomerReportData> getUserCustomerReportList(String site, String username, String reportType, String reportName) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT DISTINCT crh.id, crh.site, crh.report_id, crh.report_name, crh.report_type, crh.report_sql, crh.report_remark, crh.report_status,");
        sql.append(" crh.sort_no, crh.created_by, crh.created_date, crh.updated_by, crh.updated_date FROM customer_report_header crh");
        sql.append(" LEFT JOIN customer_report_role crr ON crr.site = crh.site AND crr.report_id = crh.report_id");
        sql.append(" LEFT JOIN sys_user_role sur ON sur.role_id = crr.role_id");
        sql.append(" LEFT JOIN sys_user su ON su.user_id = sur.user_id");
        sql.append(" WHERE crh.site = :site AND su.username = :username");
        if (!"\u5168\u90e8".equalsIgnoreCase(reportType)) {
            sql.append(" AND crh.report_type = :reportType");
            paramMap.put("reportType", reportType);
        }
        if (null != reportName && !"".equals(reportName)) {
            sql.append(" AND crh.report_name LIKE '%" + reportName + "%'");
        }
        paramMap.put("site", site);
        paramMap.put("username", username);
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(CustomerReportData.class));
    }

    @Override
    public List<CustomerReportData> getCustomerReportAuths(String site, String roleId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT DISTINCT crh.id, crh.site, crh.report_id, crh.report_name, crh.report_type, crh.report_sql, crh.report_remark, crh.report_status,");
        sql.append(" crh.sort_no, crh.created_by, crh.created_date, crh.updated_by, crh.updated_date, (CASE WHEN crr.role_id IS NULL THEN 'N' ELSE 'Y' END) authedFlag");
        sql.append(" FROM customer_report_header crh");
        sql.append(" LEFT JOIN customer_report_role crr ON crr.site = crh.site AND crr.report_id = crh.report_id AND crr.role_id = :roleId");
        sql.append(" WHERE crh.site = :site");
        paramMap.put("site", site);
        paramMap.put("roleId", roleId);
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(CustomerReportData.class));
    }

    @Override
    public void deleteCustomerReportRoleByRoleId(String roleId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("DELETE FROM customer_report_role WHERE role_id = :roleId");
        paramMap.put("roleId", roleId);
        this.parameterJdbcTemplate.update(sql.toString(), paramMap);
    }
}

