/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JDBCSyntaxTranslator {
    private String procedureName = null;
    private boolean hasReturnValueSyntax = false;
    private static final String sqlIdentifierPart = "(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))";
    private static final String sqlIdentifierWithoutGroups = "((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)";
    private static final String sqlIdentifierWithGroups = "((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?)))(?:\\.((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))))?";
    private static final Pattern jdbcCallSyntax = Pattern.compile("(?s)\\s*?\\{\\s*?(\\?\\s*?=)?\\s*?[cC][aA][lL][lL]\\s+?((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)(?:\\s*?\\((.*)\\))?\\s*\\}.*+");
    private static final Pattern sqlExecSyntax = Pattern.compile("\\s*?[eE][xX][eE][cC](?:[uU][tT][eE])??\\s+?(((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)\\s*?=\\s+?)??((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)(?:$|(?:\\s+?.*+))");
    private static final Pattern limitSyntaxWithOffset = Pattern.compile("\\{\\s*[lL][iI][mM][iI][tT]\\s+(.*)\\s+[oO][fF][fF][sS][eE][tT]\\s+(.*)\\}");
    private static final Pattern limitSyntaxGeneric = Pattern.compile("\\{\\s*[lL][iI][mM][iI][tT]\\s+(.*)(\\s+[oO][fF][fF][sS][eE][tT](.*)\\}|\\s*\\})");
    private static final Pattern selectPattern = Pattern.compile("([sS][eE][lL][eE][cC][tT])\\s+");
    private static final Pattern openQueryPattern = Pattern.compile("[oO][pP][eE][nN][qQ][uU][eE][rR][yY]\\s*\\(.*,\\s*'(.*)'\\s*\\)");
    private static final Pattern openRowsetPattern = Pattern.compile("[oO][pP][eE][nN][rR][oO][wW][sS][eE][tT]\\s*\\(.*,.*,\\s*'(.*)'\\s*\\)");
    private static final Pattern limitOnlyPattern = Pattern.compile("\\{\\s*[lL][iI][mM][iI][tT]\\s+(((\\(|\\s)*)(\\d*|\\?)((\\)|\\s)*))\\s*\\}");

    JDBCSyntaxTranslator() {
    }

    String getProcedureName() {
        return this.procedureName;
    }

    boolean hasReturnValueSyntax() {
        return this.hasReturnValueSyntax;
    }

    static String getSQLIdentifierWithGroups() {
        return sqlIdentifierWithGroups;
    }

    int translateLimit(StringBuffer stringBuffer, int n, char c) throws SQLServerException {
        Matcher matcher = selectPattern.matcher(stringBuffer);
        Matcher matcher2 = openQueryPattern.matcher(stringBuffer);
        Matcher matcher3 = openRowsetPattern.matcher(stringBuffer);
        Matcher matcher4 = limitOnlyPattern.matcher(stringBuffer);
        Matcher matcher5 = limitSyntaxWithOffset.matcher(stringBuffer);
        int n2 = n;
        Stack<Integer> stack = new Stack<Integer>();
        State state = State.START;
        while (n < stringBuffer.length()) {
            char c2 = stringBuffer.charAt(n);
            switch (state) {
                case START: {
                    state = State.PROCESS;
                    break;
                }
                case PROCESS: {
                    if (c == c2) {
                        state = State.END;
                        break;
                    }
                    if ('\'' == c2) {
                        state = State.QUOTE;
                        break;
                    }
                    if ('(' == c2) {
                        state = State.SUBQUERY;
                        break;
                    }
                    if (matcher4.find(n) && n == matcher4.start()) {
                        state = State.LIMIT;
                        break;
                    }
                    if (matcher5.find(n) && n == matcher5.start()) {
                        state = State.OFFSET;
                        break;
                    }
                    if (matcher2.find(n) && n == matcher2.start()) {
                        state = State.OPENQUERY;
                        break;
                    }
                    if (matcher3.find(n) && n == matcher3.start()) {
                        state = State.OPENROWSET;
                        break;
                    }
                    if (matcher.find(n) && n == matcher.start()) {
                        state = State.SELECT;
                        break;
                    }
                    ++n;
                    break;
                }
                case OFFSET: {
                    throw new SQLServerException(SQLServerException.getErrString("R_limitOffsetNotSupported"), null, 0, null);
                }
                case LIMIT: {
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = -1;
                    String string = matcher4.group(2);
                    String string2 = matcher4.group(5);
                    while (-1 != (n5 = string.indexOf(40, n5 + 1))) {
                        ++n3;
                    }
                    n5 = -1;
                    while (-1 != (n5 = string2.indexOf(41, n5 + 1))) {
                        ++n4;
                    }
                    if (n3 != n4) {
                        throw new SQLServerException(SQLServerException.getErrString("R_limitEscapeSyntaxError"), null, 0, null);
                    }
                    if (!stack.empty()) {
                        Integer n6 = (Integer)stack.pop();
                        String string3 = matcher4.group(1);
                        stringBuffer.delete(matcher4.start() - 1, matcher4.end());
                        if ('?' == string3.charAt(0)) {
                            stringBuffer.insert((int)n6, " TOP (" + string3 + ")");
                            n += 7 + string3.length() - 1;
                        } else {
                            stringBuffer.insert((int)n6, " TOP " + string3);
                            n += 5 + string3.length() - 1;
                        }
                    } else {
                        n = matcher4.end() - 1;
                    }
                    state = State.PROCESS;
                    break;
                }
                case SELECT: {
                    n = matcher.end(1);
                    stack.push(n);
                    state = State.PROCESS;
                    break;
                }
                case QUOTE: {
                    if (stringBuffer.length() > ++n && '\'' == stringBuffer.charAt(n)) {
                        if (stringBuffer.length() > ++n && '\'' == stringBuffer.charAt(n)) {
                            state = State.QUOTE;
                            break;
                        }
                        state = State.PROCESS;
                        break;
                    }
                    state = State.QUOTE;
                    break;
                }
                case SUBQUERY: {
                    ++n;
                    n += this.translateLimit(stringBuffer, n, ')');
                    state = State.PROCESS;
                    break;
                }
                case OPENQUERY: {
                    n = matcher2.start(1);
                    n += this.translateLimit(stringBuffer, n, '\'');
                    state = State.PROCESS;
                    break;
                }
                case OPENROWSET: {
                    n = matcher3.start(1);
                    n += this.translateLimit(stringBuffer, n, '\'');
                    state = State.PROCESS;
                    break;
                }
                case END: {
                    return ++n - n2;
                }
            }
        }
        return n - n2;
    }

    String translate(String string) throws SQLServerException {
        CharSequence charSequence;
        Matcher matcher = jdbcCallSyntax.matcher(string);
        if (matcher.matches()) {
            this.hasReturnValueSyntax = null != matcher.group(1);
            this.procedureName = matcher.group(2);
            charSequence = matcher.group(3);
            string = "EXEC " + (this.hasReturnValueSyntax ? "? = " : "") + this.procedureName + (null != charSequence ? " " + (String)charSequence : "");
        } else {
            matcher = sqlExecSyntax.matcher(string);
            if (matcher.matches()) {
                this.hasReturnValueSyntax = null != matcher.group(1);
                this.procedureName = matcher.group(3);
            }
        }
        matcher = limitSyntaxGeneric.matcher(string);
        if (matcher.find()) {
            charSequence = new StringBuffer(string);
            this.translateLimit((StringBuffer)charSequence, 0, '\u0000');
            return ((StringBuffer)charSequence).toString();
        }
        return string;
    }

    static enum State {
        START,
        END,
        SUBQUERY,
        SELECT,
        OPENQUERY,
        OPENROWSET,
        LIMIT,
        OFFSET,
        QUOTE,
        PROCESS;

    }
}

