/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ISQLServerDataRecord;
import com.microsoft.sqlserver.jdbc.SQLServerDataColumn;
import com.microsoft.sqlserver.jdbc.SQLServerDataTable;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerSortOrder;
import com.microsoft.sqlserver.jdbc.TVPType;
import com.microsoft.sqlserver.jdbc.Util;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class TVP {
    String TVPName;
    String TVP_owningSchema;
    String TVP_dbName;
    ResultSet sourceResultSet = null;
    SQLServerDataTable sourceDataTable = null;
    Map<Integer, SQLServerMetaData> columnMetadata = null;
    Iterator<Map.Entry<Integer, Object[]>> sourceDataTableRowIterator = null;
    ISQLServerDataRecord sourceRecord = null;
    TVPType tvpType = null;

    void initTVP(TVPType tVPType, String string) throws SQLServerException {
        this.tvpType = tVPType;
        this.columnMetadata = new LinkedHashMap<Integer, SQLServerMetaData>();
        this.parseTypeName(string);
    }

    TVP(String string) throws SQLServerException {
        this.initTVP(TVPType.Null, string);
    }

    TVP(String string, SQLServerDataTable sQLServerDataTable) throws SQLServerException {
        this.initTVP(TVPType.SQLServerDataTable, string);
        this.sourceDataTable = sQLServerDataTable;
        this.sourceDataTableRowIterator = this.sourceDataTable.getIterator();
        this.populateMetadataFromDataTable();
    }

    TVP(String string, ResultSet resultSet) throws SQLServerException {
        this.initTVP(TVPType.ResultSet, string);
        this.sourceResultSet = resultSet;
        this.populateMetadataFromResultSet();
    }

    TVP(String string, ISQLServerDataRecord iSQLServerDataRecord) throws SQLServerException {
        this.initTVP(TVPType.ISQLServerDataRecord, string);
        this.sourceRecord = iSQLServerDataRecord;
        this.populateMetadataFromDataRecord();
        this.validateOrderProperty();
    }

    boolean isNull() {
        return TVPType.Null == this.tvpType;
    }

    Object[] getRowData() throws SQLServerException {
        if (TVPType.ResultSet == this.tvpType) {
            int n = this.columnMetadata.size();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                try {
                    objectArray[i] = this.sourceResultSet.getObject(i + 1);
                    continue;
                }
                catch (SQLException sQLException) {
                    throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLException);
                }
            }
            return objectArray;
        }
        if (TVPType.SQLServerDataTable == this.tvpType) {
            Map.Entry<Integer, Object[]> entry = this.sourceDataTableRowIterator.next();
            return entry.getValue();
        }
        return this.sourceRecord.getRowData();
    }

    boolean next() throws SQLServerException {
        if (TVPType.ResultSet == this.tvpType) {
            try {
                return this.sourceResultSet.next();
            }
            catch (SQLException sQLException) {
                throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLException);
            }
        }
        if (TVPType.SQLServerDataTable == this.tvpType) {
            return this.sourceDataTableRowIterator.hasNext();
        }
        return this.sourceRecord.next();
    }

    void populateMetadataFromDataTable() throws SQLServerException {
        assert (null != this.sourceDataTable);
        Map<Integer, SQLServerDataColumn> map = this.sourceDataTable.getColumnMetadata();
        if (null == map || map.isEmpty()) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPEmptyMetadata"), null);
        }
        for (Map.Entry<Integer, SQLServerDataColumn> entry : map.entrySet()) {
            this.columnMetadata.put(entry.getKey(), new SQLServerMetaData(entry.getValue().columnName, entry.getValue().javaSqlType, entry.getValue().precision, entry.getValue().scale));
        }
    }

    void populateMetadataFromResultSet() throws SQLServerException {
        assert (null != this.sourceResultSet);
        try {
            ResultSetMetaData resultSetMetaData = this.sourceResultSet.getMetaData();
            for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                SQLServerMetaData sQLServerMetaData = new SQLServerMetaData(resultSetMetaData.getColumnName(i + 1), resultSetMetaData.getColumnType(i + 1), resultSetMetaData.getPrecision(i + 1), resultSetMetaData.getScale(i + 1));
                this.columnMetadata.put(i, sQLServerMetaData);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), sQLException);
        }
    }

    void populateMetadataFromDataRecord() throws SQLServerException {
        assert (null != this.sourceRecord);
        if (0 >= this.sourceRecord.getColumnCount()) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPEmptyMetadata"), null);
        }
        for (int i = 0; i < this.sourceRecord.getColumnCount(); ++i) {
            Util.checkDuplicateColumnName(this.sourceRecord.getColumnMetaData((int)(i + 1)).columnName, this.columnMetadata);
            SQLServerMetaData sQLServerMetaData = new SQLServerMetaData(this.sourceRecord.getColumnMetaData(i + 1));
            this.columnMetadata.put(i, sQLServerMetaData);
        }
    }

    void validateOrderProperty() throws SQLServerException {
        Object object;
        int n = this.columnMetadata.size();
        boolean[] blArray = new boolean[n];
        int n2 = -1;
        int n3 = 0;
        for (Map.Entry<Integer, SQLServerMetaData> entry : this.columnMetadata.entrySet()) {
            object = entry.getValue().sortOrder;
            int n4 = entry.getValue().sortOrdinal;
            if (SQLServerSortOrder.Unspecified == object) continue;
            if (n <= n4) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_TVPSortOrdinalGreaterThanFieldCount"));
                throw new SQLServerException(messageFormat.format(new Object[]{n4, entry.getKey()}), null, 0, null);
            }
            if (blArray[n4]) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_TVPDuplicateSortOrdinal"));
                throw new SQLServerException(messageFormat.format(new Object[]{n4}), null, 0, null);
            }
            blArray[n4] = true;
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        if (0 < n3 && n2 >= n3) {
            int n5;
            for (n5 = 0; n5 < n3 && blArray[n5]; ++n5) {
            }
            object = new MessageFormat(SQLServerException.getErrString("R_TVPMissingSortOrdinal"));
            throw new SQLServerException(((Format)object).format(new Object[]{n5}), null, 0, null);
        }
    }

    void parseTypeName(String string) throws SQLServerException {
        int n;
        int n2;
        String string2 = "[\"";
        String string3 = "]\"";
        char c = '.';
        int n3 = 3;
        String[] stringArray = new String[n3];
        int n4 = 0;
        if (null == string || 0 == string.length()) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidTVPName"));
            Object[] objectArray = new Object[]{};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringBuilder stringBuilder2 = null;
        char c2 = ' ';
        MPIState mPIState = MPIState.MPI_Value;
        block12: for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            switch (mPIState) {
                case MPI_Value: {
                    if (Character.isWhitespace((char)n)) continue block12;
                    if (n == c) {
                        stringArray[n4] = "";
                        ++n4;
                        continue block12;
                    }
                    int n5 = string2.indexOf(n);
                    if (-1 != n5) {
                        c2 = string3.charAt(n5);
                        stringBuilder.setLength(0);
                        mPIState = MPIState.MPI_ParseQuote;
                        continue block12;
                    }
                    if (-1 != string3.indexOf(n)) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidThreePartName"));
                        throw new SQLServerException(null, messageFormat.format(new Object[0]), null, 0, false);
                    }
                    stringBuilder.setLength(0);
                    stringBuilder.append((char)n);
                    mPIState = MPIState.MPI_ParseNonQuote;
                    continue block12;
                }
                case MPI_ParseNonQuote: {
                    if (n == c) {
                        stringArray[n4] = stringBuilder.toString();
                        n4 = this.incrementStringCount(stringArray, n4);
                        mPIState = MPIState.MPI_Value;
                        continue block12;
                    }
                    if (-1 != string3.indexOf(n) || -1 != string2.indexOf(n)) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidThreePartName"));
                        throw new SQLServerException(null, messageFormat.format(new Object[0]), null, 0, false);
                    }
                    if (Character.isWhitespace((char)n)) {
                        stringArray[n4] = stringBuilder.toString();
                        if (null == stringBuilder2) {
                            stringBuilder2 = new StringBuilder();
                        }
                        stringBuilder2.setLength(0);
                        stringBuilder2.append((char)n);
                        mPIState = MPIState.MPI_LookForNextCharOrSeparator;
                        continue block12;
                    }
                    stringBuilder.append((char)n);
                    continue block12;
                }
                case MPI_LookForNextCharOrSeparator: {
                    if (!Character.isWhitespace((char)n)) {
                        if (n == c) {
                            n4 = this.incrementStringCount(stringArray, n4);
                            mPIState = MPIState.MPI_Value;
                            continue block12;
                        }
                        stringBuilder.append((CharSequence)stringBuilder2);
                        stringBuilder.append((char)n);
                        stringArray[n4] = stringBuilder.toString();
                        mPIState = MPIState.MPI_ParseNonQuote;
                        continue block12;
                    }
                    stringBuilder2.append((char)n);
                    continue block12;
                }
                case MPI_ParseQuote: {
                    if (n == c2) {
                        mPIState = MPIState.MPI_RightQuote;
                        continue block12;
                    }
                    stringBuilder.append((char)n);
                    continue block12;
                }
                case MPI_RightQuote: {
                    if (n == c2) {
                        stringBuilder.append((char)n);
                        mPIState = MPIState.MPI_ParseQuote;
                        continue block12;
                    }
                    if (n == c) {
                        stringArray[n4] = stringBuilder.toString();
                        n4 = this.incrementStringCount(stringArray, n4);
                        mPIState = MPIState.MPI_Value;
                        continue block12;
                    }
                    if (!Character.isWhitespace((char)n)) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidThreePartName"));
                        throw new SQLServerException(null, messageFormat.format(new Object[0]), null, 0, false);
                    }
                    stringArray[n4] = stringBuilder.toString();
                    mPIState = MPIState.MPI_LookForSeparator;
                    continue block12;
                }
                case MPI_LookForSeparator: {
                    if (Character.isWhitespace((char)n)) continue block12;
                    if (n == c) {
                        n4 = this.incrementStringCount(stringArray, n4);
                        mPIState = MPIState.MPI_Value;
                        continue block12;
                    }
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidThreePartName"));
                    throw new SQLServerException(null, messageFormat.format(new Object[0]), null, 0, false);
                }
            }
        }
        if (n4 > n3 - 1) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidThreePartName"));
            throw new SQLServerException(null, messageFormat.format(new Object[0]), null, 0, false);
        }
        switch (mPIState) {
            case MPI_Value: 
            case MPI_LookForNextCharOrSeparator: 
            case MPI_LookForSeparator: {
                break;
            }
            case MPI_ParseNonQuote: 
            case MPI_RightQuote: {
                stringArray[n4] = stringBuilder.toString();
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidThreePartName"));
                throw new SQLServerException(null, messageFormat.format(new Object[0]), null, 0, false);
            }
        }
        if (stringArray[0] == null) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidThreePartName"));
            throw new SQLServerException(null, messageFormat.format(new Object[0]), null, 0, false);
        }
        n2 = n3 - n4 - 1;
        if (n2 > 0) {
            for (n = n3 - 1; n >= n2; --n) {
                stringArray[n] = stringArray[n - n2];
                stringArray[n - n2] = null;
            }
        }
        this.TVPName = stringArray[2];
        this.TVP_owningSchema = stringArray[1];
        this.TVP_dbName = stringArray[0];
    }

    private int incrementStringCount(String[] stringArray, int n) throws SQLServerException {
        int n2 = stringArray.length;
        if (++n >= n2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidThreePartName"));
            throw new SQLServerException(null, messageFormat.format(new Object[0]), null, 0, false);
        }
        stringArray[n] = new String();
        return n;
    }

    String getTVPName() {
        return this.TVPName;
    }

    String getDbNameTVP() {
        return this.TVP_dbName;
    }

    String getOwningSchemaNameTVP() {
        return this.TVP_owningSchema;
    }

    int getTVPColumnCount() {
        return this.columnMetadata.size();
    }

    Map<Integer, SQLServerMetaData> getColumnMetadata() {
        return this.columnMetadata;
    }

    static enum MPIState {
        MPI_Value,
        MPI_ParseNonQuote,
        MPI_LookForSeparator,
        MPI_LookForNextCharOrSeparator,
        MPI_ParseQuote,
        MPI_RightQuote;

    }
}

