/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ISQLServerDataRecord;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.LocalDate;
import com.microsoft.sqlserver.jdbc.LocalDateTime;
import com.microsoft.sqlserver.jdbc.LocalTime;
import com.microsoft.sqlserver.jdbc.OffsetDateTime;
import com.microsoft.sqlserver.jdbc.OffsetTime;
import com.microsoft.sqlserver.jdbc.SQLServerDataTable;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TVP;
import com.microsoft.sqlserver.jdbc.TemporalCompatibility;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.EnumSet;
import microsoft.sql.DateTimeOffset;

enum JavaType {
    INTEGER(Integer.class, JDBCType.INTEGER),
    STRING(String.class, JDBCType.CHAR),
    DATE(Date.class, JDBCType.DATE),
    TIME(Time.class, JDBCType.TIME),
    TIMESTAMP(Timestamp.class, JDBCType.TIMESTAMP),
    UTILDATE(java.util.Date.class, JDBCType.TIMESTAMP),
    CALENDAR(Calendar.class, JDBCType.TIMESTAMP),
    LOCALDATE(JavaType.getJavaClass("LocalDate"), JDBCType.DATE),
    LOCALTIME(JavaType.getJavaClass("LocalTime"), JDBCType.TIME),
    LOCALDATETIME(JavaType.getJavaClass("LocalDateTime"), JDBCType.TIMESTAMP),
    OFFSETTIME(JavaType.getJavaClass("OffsetTime"), JDBCType.TIME_WITH_TIMEZONE),
    OFFSETDATETIME(JavaType.getJavaClass("OffsetDateTime"), JDBCType.TIMESTAMP_WITH_TIMEZONE),
    DATETIMEOFFSET(DateTimeOffset.class, JDBCType.DATETIMEOFFSET),
    BOOLEAN(Boolean.class, JDBCType.BIT),
    BIGDECIMAL(BigDecimal.class, JDBCType.DECIMAL),
    DOUBLE(Double.class, JDBCType.DOUBLE),
    FLOAT(Float.class, JDBCType.REAL),
    SHORT(Short.class, JDBCType.SMALLINT),
    LONG(Long.class, JDBCType.BIGINT),
    BIGINTEGER(BigInteger.class, JDBCType.BIGINT),
    BYTE(Byte.class, JDBCType.TINYINT),
    BYTEARRAY(byte[].class, JDBCType.BINARY),
    NCLOB(NClob.class, JDBCType.NCLOB),
    CLOB(Clob.class, JDBCType.CLOB),
    BLOB(Blob.class, JDBCType.BLOB),
    TVP(TVP.class, JDBCType.TVP),
    INPUTSTREAM((Class)InputStream.class, JDBCType.UNKNOWN){

        @Override
        JDBCType getJDBCType(SSType sSType, JDBCType jDBCType) {
            JDBCType jDBCType2;
            if (SSType.UNKNOWN != sSType) {
                switch (sSType) {
                    case CHAR: 
                    case VARCHAR: 
                    case VARCHARMAX: 
                    case TEXT: 
                    case NCHAR: 
                    case NVARCHAR: 
                    case NVARCHARMAX: 
                    case NTEXT: {
                        jDBCType2 = JDBCType.LONGVARCHAR;
                        break;
                    }
                    default: {
                        jDBCType2 = JDBCType.LONGVARBINARY;
                        break;
                    }
                }
            } else {
                JDBCType jDBCType3 = jDBCType2 = jDBCType.isTextual() ? JDBCType.LONGVARCHAR : JDBCType.LONGVARBINARY;
            }
            assert (null != jDBCType2);
            return jDBCType2;
        }
    }
    ,
    READER(Reader.class, JDBCType.LONGVARCHAR),
    SQLXML(SQLServerSQLXML.class, JDBCType.SQLXML),
    OBJECT(Object.class, JDBCType.UNKNOWN);

    private final Class<?> javaClass;
    private final JDBCType jdbcTypeFromJavaType;
    private static double jvmVersion;

    private JavaType(Class<?> clazz, JDBCType jDBCType) {
        this.javaClass = clazz;
        this.jdbcTypeFromJavaType = jDBCType;
    }

    static Class<?> getJavaClass(String string) {
        if (0.0 == jvmVersion) {
            try {
                String string2 = System.getProperty("java.specification.version");
                if (string2 != null) {
                    jvmVersion = Double.parseDouble(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                jvmVersion = 0.1;
            }
        }
        if (jvmVersion < 1.8) {
            return TemporalCompatibility.class;
        }
        if (string.equals("LocalDate")) {
            return LocalDate.class;
        }
        if (string.equals("LocalTime")) {
            return LocalTime.class;
        }
        if (string.equals("LocalDateTime")) {
            return LocalDateTime.class;
        }
        if (string.equals("OffsetTime")) {
            return OffsetTime.class;
        }
        if (string.equals("OffsetDateTime")) {
            return OffsetDateTime.class;
        }
        return TemporalCompatibility.class;
    }

    static JavaType of(Object object) {
        if (object instanceof SQLServerDataTable || object instanceof ResultSet || object instanceof ISQLServerDataRecord) {
            return TVP;
        }
        if (null != object) {
            for (JavaType javaType : JavaType.values()) {
                if (!javaType.javaClass.isInstance(object)) continue;
                return javaType;
            }
        }
        return OBJECT;
    }

    JDBCType getJDBCType(SSType sSType, JDBCType jDBCType) {
        return this.jdbcTypeFromJavaType;
    }

    static {
        jvmVersion = 0.0;
    }

    static enum SetterConversionAE {
        BIT(BOOLEAN, EnumSet.of(JDBCType.BIT, JDBCType.TINYINT, JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT)),
        SHORT(SHORT, EnumSet.of(JDBCType.TINYINT, JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT)),
        INTEGER(INTEGER, EnumSet.of(JDBCType.INTEGER, JDBCType.BIGINT)),
        LONG(LONG, EnumSet.of(JDBCType.BIGINT)),
        BIGDECIMAL(BIGDECIMAL, EnumSet.of(JDBCType.MONEY, JDBCType.SMALLMONEY, JDBCType.DECIMAL, JDBCType.NUMERIC)),
        BYTE(BYTE, EnumSet.of(JDBCType.BINARY, JDBCType.VARBINARY, JDBCType.LONGVARBINARY, JDBCType.TINYINT)),
        BYTEARRAY(BYTEARRAY, EnumSet.of(JDBCType.BINARY, JDBCType.VARBINARY, JDBCType.LONGVARBINARY)),
        DATE(DATE, EnumSet.of(JDBCType.DATE)),
        DATETIMEOFFSET(DATETIMEOFFSET, EnumSet.of(JDBCType.DATETIMEOFFSET)),
        DOUBLE(DOUBLE, EnumSet.of(JDBCType.DOUBLE)),
        FLOAT(FLOAT, EnumSet.of(JDBCType.REAL, JDBCType.DOUBLE)),
        STRING(STRING, EnumSet.of(JDBCType.CHAR, new JDBCType[]{JDBCType.VARCHAR, JDBCType.LONGVARCHAR, JDBCType.NCHAR, JDBCType.NVARCHAR, JDBCType.LONGNVARCHAR, JDBCType.GUID})),
        TIME(TIME, EnumSet.of(JDBCType.TIME)),
        TIMESTAMP(TIMESTAMP, EnumSet.of(JDBCType.TIME, JDBCType.TIMESTAMP, JDBCType.DATETIME, JDBCType.SMALLDATETIME));

        private final EnumSet<JDBCType> to;
        private final JavaType from;
        private static final EnumMap<JavaType, EnumSet<JDBCType>> setterConversionAEMap;

        private SetterConversionAE(JavaType javaType, EnumSet<JDBCType> enumSet) {
            this.from = javaType;
            this.to = enumSet;
        }

        static boolean converts(JavaType javaType, JDBCType jDBCType) {
            if (null == javaType || OBJECT == javaType) {
                return true;
            }
            if (!setterConversionAEMap.containsKey((Object)javaType)) {
                return false;
            }
            return setterConversionAEMap.get((Object)javaType).contains((Object)jDBCType);
        }

        static {
            setterConversionAEMap = new EnumMap(JavaType.class);
            for (JavaType enum_ : JavaType.values()) {
                setterConversionAEMap.put(enum_, EnumSet.noneOf(JDBCType.class));
            }
            for (Enum enum_ : SetterConversionAE.values()) {
                setterConversionAEMap.get((Object)((SetterConversionAE)enum_).from).addAll(((SetterConversionAE)enum_).to);
            }
        }
    }
}

