//公共参数
var authTrees;//权限树结构

//页面加载完事件
$(function(){
	localStorage.removeItem("authTrees")
	getMenu();
	//加载权限树
	// getAuthTree();
	//加载树结构标签
	initAuthMenu();
	//清除所有cookie函数
	// cleanCookie();
});

function getMenu(){
	localStorage.setItem("returnPage",null)
	localStorage.setItem("titleName",null)
	var languageDefault = $("#current_languageDefault").val();
	var menuType = "pda";
	var token = $.cookie("token");
	var jsonData = {
		l : languageDefault,
		menuType : menuType,
		token: token,
	}
	$.ajax({
		url: "/sys/menu/nav",
		contentType: 'application/json',
		type:"GET",
		data:jsonData,//你的formid
		dataType:"JSON",
		async: false,
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success: function (data) {
			if (data.code == 0) {
				authTrees = data.menuList;
				localStorage.setItem("authTrees",JSON.stringify(authTrees))
			}else if(data.code == 401 || data.code == 500){
				window.location.href="/login";
			}else {
				layer.msg(data.msg);
			}
		},
		error: function(data) {
			var responseText = data.responseText;
			var json_str = JSON.parse(responseText);
			var status = json_str.status;
			var message = json_str.message;
			//判断是否是session超时
			if(403==status){
				layer.alert(message,function(){
					window.location.href="/login";
				});
			}
			layer.closeAll('loading');
		}
	});
}

function cleanCookie(){
	var keys = document.cookie.match(/[^ =;]+(?=\=)/g);
	if(keys) {
		for(var i = keys.length; i--;){
			document.cookie = keys[i] + '=0;expires=' + new Date(0).toUTCString()
		}
	}
}

// //获取权限树结构
// function getAuthTree(){
// 	$.ajax({
//       url: "/base/getMenusByUsername",
//       type: "POST",
//       async: false,
//       data: {"username": $("#current_username").val(),
//     	  	 "authKey": ''},// 你的formid
//       dataType: "JSON",
//       success: function (data) {
//       if (data.success) {
//     	  authTrees = data.rows;
//       	}else{
//       		layer.msg(data.msg);
//       	}
//       },
//       error: function(data) {
//       	var responseText = data.responseText;
//       	var json_str = JSON.parse(responseText);
//       	var status = json_str.status;
//       	var message = json_str.message;
//       	//判断是否是session超时
//       	if(403==status){
//       		layer.alert(message,function(){
//       			window.location.href="/login";
//       		});
//       	}
//       	layer.closeAll('loading');
//       }
//   });
// }

//初始化树结构
function initAuthMenu(){
	//权限的标签
	var authTags = '';
	//循环处理标签
	if(authTrees != null){
		for(var i = 0; i < authTrees.length; i++){
			//处理标签逻辑
			authTag = processMenuTags(authTrees[i]);
			authTags += authTag;
		}
		//替换标签
		$("#main-menu").append(authTags);
	}
}

//处理权限的菜单
function processMenuTags(authTree){
	//公共参数
	var id = authTree.menuId;
	var url = ""
	var titleName = ""
	if(authTree.type == 0){
		url = "/pda/publicMenu"
		titleName = "&titleName=" + authTree.name
	}else {
		url = authTree.url
	}
	url = url + "?menuId=" + authTree.menuId + "&token=" +  $.cookie("token")+titleName;
	var name = authTree.name;
	var authTag = '<div data-v-45aee492="" class="ivu-row" style ="margin: 20px;margin-top: -3px;">';
	authTag += '<div data-v-45aee492="" class="ivu-col ivu-col-span-13 ivu-col-offset-5" style="width: 105%;margin-left: -7px;">';
	authTag += '<a data-v-45aee492="" type="button" id="'+id+'" href="'+url+'"';
	authTag += 'class="ivu-btn ivu-btn-primary ivu-btn-long" >';  //style = "border-color: #FF7F24;"
	authTag += '<span style="font-size: 20px">'+name+'</span>';
	authTag += '</a></div></div>';
	return authTag;
}