/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.app.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="gaotao.jwt")
@Component
public class JwtUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String secret;
    private long expire;
    private String header;

    public String generateToken(long userId) {
        Date nowDate = new Date();
        Date expireDate = new Date(nowDate.getTime() + this.expire * 1000L);
        return ((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setHeaderParam("typ", (Object)"JWT").setSubject("" + userId)).setIssuedAt(nowDate)).setExpiration(expireDate)).signWith((Key)Keys.hmacShaKeyFor((byte[])this.secret.getBytes(StandardCharsets.UTF_8))).compact();
    }

    public Claims getClaimByToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.secret).build().parseClaimsJws((CharSequence)token).getBody();
        }
        catch (Exception e) {
            this.logger.debug("validate is token error ", (Throwable)e);
            return null;
        }
    }

    public boolean isTokenExpired(Date expiration) {
        return expiration.before(new Date());
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

