/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.TDSReader;

final class StreamError
extends StreamPacket {
    String errorMessage = "";
    int errorNumber;
    int errorState;
    int errorSeverity;
    String serverName;
    String procName;
    long lineNumber;

    final String getMessage() {
        return this.errorMessage;
    }

    final int getErrorNumber() {
        return this.errorNumber;
    }

    final int getErrorState() {
        return this.errorState;
    }

    final int getErrorSeverity() {
        return this.errorSeverity;
    }

    StreamError() {
        super(170);
    }

    @Override
    void setFromTDS(TDSReader tDSReader) throws SQLServerException {
        if (170 != tDSReader.readUnsignedByte()) assert (false);
        this.setContentsFromTDS(tDSReader);
    }

    void setContentsFromTDS(TDSReader tDSReader) throws SQLServerException {
        tDSReader.readUnsignedShort();
        this.errorNumber = tDSReader.readInt();
        this.errorState = tDSReader.readUnsignedByte();
        this.errorSeverity = tDSReader.readUnsignedByte();
        this.errorMessage = tDSReader.readUnicodeString(tDSReader.readUnsignedShort());
        this.serverName = tDSReader.readUnicodeString(tDSReader.readUnsignedByte());
        this.procName = tDSReader.readUnicodeString(tDSReader.readUnsignedByte());
        this.lineNumber = tDSReader.readUnsignedInt();
    }
}

