
var userId = $("#current_id").val();
var userName = $("#current_username").val();
var site = $("#current_site").val();


var toolDetailList = new Array();
var locationDate;

//页面初始化
$(function(){
	//	初始化录入时间
	InitStorageTime();
//	初始化光标
	$("#tool_detail").focus();	
});

// 初始化入库日期
function InitStorageTime(){
	var data = getNowFormatDate();
	data = data.substring(0, 10);
	$("#storage_time").val(data);
}

//为工具实例条码绑定一个失去焦点事件
$("#tool_detail").bind("keydown",function(event){
	if (event.keyCode == 13) {
		var toolInstanceId = $(this).val();
		if(toolInstanceId == null || toolInstanceId == ""){
			layer.msg("请输入正确的实例编码!");
			$(this).val("");
			$(this).focus();
		}else {
			getToolInstanceData(toolInstanceId);
		}
	}
});

//为工具实例条码绑定一个失去焦点事件
$("#locationId").bind("keydown",function(event){
	if (event.keyCode == 13) {
		var locationId = $(this).val();
		if(locationId == null || locationId == ""){
			layer.msg("请输入正确的库位编码!");
			$(this).val("");
			$(this).focus();
		}else {
			getLocation(locationId);
		}
	}
});

// 获取获取工具实例编码
function getToolInstanceData(toolInstanceId){
	$("#tool_detail").val("");
	var jsonData = {
		site : site,
		toolInstanceId : toolInstanceId,
	}
	$.ajax({
		url: "/toolPda/getToolDetail",
		contentType: 'application/json',
		type:"POST",
		data:JSON.stringify(jsonData),//你的formid
		dataType:"JSON",
		async: false,
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success: function (data) {
			var row = data.row;
			if(row != null || row == ""){
				if(row.status != "出库"){
					layer.msg("该工具状态位["+row.status+"],不能进行维修返回!");
					return false;
				}
				 if(row.statusRef != "维修出库"){
					layer.msg("该工具不能维修返回!");
					return false;
				}
				for (let i = 0; i < toolDetailList.length; i++) {
					if(toolDetailList[i].toolInstanceId == row.toolInstanceId){
						layer.msg("已有该工具记录!");
						$("#tool_detail").focus();
						return;
					}
				}
				toolDetailList.push(row);
				var str = '<tr id = '+row.toolInstanceId+'>' +
					'<th class="" style="text-align:center;background-color: #ffff;">' +
					'<span>'+row.toolInstanceId+'</span></th>' +
					'<th class="" style="text-align:center;background-color: #ffff;">' +
					'<span>'+row.toolDescription+'</span></th>' +
					'<th class="" style="text-align:center;background-color: #ffff;">' +
					'<span>'+row.locationId+'</span></th>' +
					'<th class="" style="text-align:center;background-color: #ffff;">' +
					'<button  data-toggle="modal" onclick="remove(\''+row.toolInstanceId +'\')" style="padding: 3px 10px;">' +
					'删除</button>'	+
					'</tr>';
				$("#dateil_table").append(str);
				$("#tool_detail").focus();
			}else{
				layer.msg("没有该工具记录!");
			}
		},
		error: function(data) {
			var responseText = data.responseText;
			var json_str = JSON.parse(responseText);
			var status = json_str.status;
			var message = json_str.message;
			//判断是否是session超时
			if(403==status){
				layer.alert(message,function(){
					window.location.href="/login";
				});
			}
			layer.closeAll('loading');
		}
	})
}

//删除
function remove(toolInstanceId){
	for (var i = 0; i < toolDetailList.length; i++) {
		if(toolDetailList[i].toolInstanceId == toolInstanceId){
			toolDatailRemo(toolDetailList[i].toolInstanceId);
			toolDetailList.splice(i,1);
			layer.msg("移除成功!");
			$("#tool_detail").val("");
			$("#tool_detail").focus();
			return false;
		}
	}
	layer.msg("没有该工具记录!");
	$("#tool_detail").val("");
}


// 移除工具实例编码
function toolDatailRemo(toolInstanceId){
	$table=$("#dateil_table tr");
	$("tr[id='" + toolInstanceId + "']").remove();
}

// 初始化库位条码
function initLocation(){
	if(toolDetailList.length == 0){
		layer.msg("请录入实例编码!");
		return false;
	}
	$("#locationId").val("");
	$("#location_modal").modal();
}

//模态框显示触发
$("#location_modal").on("shown.bs.modal",function(){
	$("#locationId").focus();

});
//模态框隐藏触发
$("#location_modal").on("hidden.bs.modal",function(){
	$("#tool_detail").focus();

});

// 判断库位条码是否为空
function getLocation(locationId){
	var jsonData = {
		site : site,
		locationId : locationId,
	}
	$.ajax({
		url: "/toolPda/getLocation",
		contentType: 'application/json',
		type:"POST",
		data:JSON.stringify(jsonData),//你的formid
		dataType:"JSON",
		async: false,
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success: function (data) {
			if(data.code == 0){
				if(data.row == null || data.row == ""){
					layer.msg("没有该库位条码!");
					$("#locationId").val("");
					$("#locationId").focus();
					return ;
				}
				locationDate = data.row;
				updateToolDetail();
			}
		},
		error: function(data) {
			console.log("locationId22:" +data);
			var responseText = data.responseText;
			var json_str = JSON.parse(responseText);
			var status = json_str.status;
			var message = json_str.message;
			//判断是否是session超时
			if(403==status){
				layer.alert(message,function(){
					window.location.href="/login";
				});
			}
			layer.closeAll('loading');
		}
	})
}


//新增库位信息
function updateToolDetail(){
	$("#saveDetail").attr('disabled' ,true);
	var locationId = $("#locationId").val();
	var transPrice = $("#transPrice").val();
	var lifespan = $("#lifespan").val();
	if (!transPrice){
		layer.msg("请输入维修金额!");
		return;
	}
	if (!lifespan){
		layer.msg("请输入本次维修寿命!");
		return;
	}
	var alreadyList = new Array;
	let remark = $('#remark').val()
	for(var i = 0; i< toolDetailList.length; i++){
		jsonData = {
			toolId:toolDetailList[i].toolId,
			site:toolDetailList[i].site,
			toolInstanceId:toolDetailList[i].toolInstanceId,
			warehouseId : locationDate.wareHouseId,
			locationId:locationId.toUpperCase(),
			supplierId: toolDetailList[i].supplierId,
			transNoHead:'TWF',
			transType:'维修返回',
			transTypeDb:'WF',
			direction : "+",
			userName :userName,
			status: "已投用",
			statusRef: "",
			remark: remark,
			transPrice: transPrice,
			lifespan:lifespan
		};
		alreadyList.push(jsonData);
	}
	$.ajax({
		url: "/toolPda/updateToolDetail",
		contentType: 'application/json',
		type:"POST",
		data:JSON.stringify(alreadyList),
		dataType:"JSON",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success: function (data) {
			$("#saveDetail").attr('disabled' ,false);
			if(data.code == 0){
				layer.msg(data.msg);
				toolDetailList = new Array;
				$("#dateil_table").html("");
				$("#tool_detail").val("");
				$('#remark').val('')
				//触发隐藏
				$("#location_modal").modal("hide");
			}else if(data.code == 401){
				window.location.href="/login";
			}else{
				layer.msg(data.msg);
			}
		},
		error: function(data) {
			var responseText = data.responseText;
			var json_str = JSON.parse(responseText);
			var status = json_str.status;
			var message = json_str.message;
			//判断是否是session超时
			if(403==status){
				layer.alert(message,function(){
					window.location.href="/login";
				});
			}
			layer.closeAll('loading');
		}
	})
}

//新增库位信息
function saveWareHouse(){
	var alreadyList = new Array;
	var locationId = $("#warehouse_detail").val();
	locationId = locationId.toUpperCase();
/*	if(locationId == null || locationId == ""){
		layer.msg("请输入库位条码!");
		return false;
	}*/
	if(toolDatail.length == 0){
		layer.msg("请录入工具实例!");
		return false;
	}
	if(warehouseData.length == 0){
		layer.msg("请录入库位信息!");
		return false;
	}
	for(var i = 0; i< toolDatail.length; i++){
		jsonData = {
			toolId:toolDatail[i].toolId,
			site:toolDatail[i].site,
			toolInstanceId:toolDatail[i].toolInstanceId,
			warehouseId : warehouseData[0].warehouseId,
			locationId:locationId,
			supplierId:toolDatail[i].supplierId,
			transNoHead:'TR',
			transType:'工具入库',
			transTypeDb:'R'
		};
		alreadyList.push(jsonData);
	}
	$.ajax({
        url: "/pdaToolMan/saveDatail",
        contentType: 'application/json',
        type:"POST",
        data:JSON.stringify(alreadyList),
        dataType:"JSON",
        success: function (data) {
        	if(data.success){
        		toolDatail = new Array;
        		warehouseData = new Array;
        		layer.msg(data.msg);
        		$("#dateil_table").html("");
    			$("#warehouse_detail").val("");
    			$("#tool_detail").val("");
    			//触发隐藏
    			$("#warehouse_modal").modal("hide");
        	}else{
        		layer.msg(data.msg);
        	}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.location.href="/login";
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}
//清除前台缓存
function cleanData(){
	toolDatail = new Array;
	warehouseData = new Array;
	$("#dateil_table").html("");
}
