/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.report.dao.impl;

import com.gaotao.modules.report.dao.ProcedureDao;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class ProcedureDaoImpl
implements ProcedureDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public List<Map<String, Object>> getProcedureData(final String procedureName, final List<Object> params) {
        return (List)this.jdbcTemplate.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                StringBuilder sql = new StringBuilder("EXEC " + procedureName + " ");
                for (int i = 0; i < params.size(); ++i) {
                    if (i == params.size() - 1) {
                        sql.append(" ?");
                        continue;
                    }
                    sql.append(" ?,");
                }
                CallableStatement cs = con.prepareCall(sql.toString());
                for (int i = 1; i <= params.size(); ++i) {
                    Object tempParam = params.get(i - 1);
                    if (tempParam instanceof String) {
                        cs.setString(i, String.valueOf(tempParam));
                        continue;
                    }
                    if (tempParam instanceof Integer) {
                        cs.setInt(i, Integer.parseInt(String.valueOf(tempParam)));
                        continue;
                    }
                    if (tempParam instanceof Float) {
                        cs.setFloat(i, Float.parseFloat(String.valueOf(tempParam)));
                        continue;
                    }
                    if (tempParam instanceof Double) {
                        cs.setDouble(i, Double.parseDouble(String.valueOf(tempParam)));
                        continue;
                    }
                    if (tempParam instanceof BigDecimal) {
                        cs.setBigDecimal(i, (BigDecimal)tempParam);
                        continue;
                    }
                    if (!(tempParam instanceof Date)) continue;
                    cs.setDate(i, (Date)tempParam, Calendar.getInstance());
                }
                return cs;
            }
        }, (CallableStatementCallback)new CallableStatementCallback<List<Map<String, Object>>>(this){

            public List<Map<String, Object>> doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
                ResultSet rs = cs.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                int columns = rsmd.getColumnCount();
                HashMap columnMap = new HashMap();
                for (int i = 1; i <= columns; ++i) {
                    columnMap.put(rsmd.getColumnName(i), null);
                }
                while (rs.next()) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    for (String str : columnMap.keySet()) {
                        resultMap.put(str, rs.getObject(str));
                    }
                    resultList.add(resultMap);
                }
                return resultList;
            }
        });
    }

    @Override
    public void execProduceData(String procedureName, List<Object> params) {
        StringBuilder sql = new StringBuilder("EXEC " + procedureName + " ");
        for (int i = 0; i < params.size(); ++i) {
            if (i == params.size() - 1) {
                sql.append("'" + String.valueOf(params.get(i)) + "'");
                continue;
            }
            sql.append("'" + String.valueOf(params.get(i)) + "', ");
        }
        this.jdbcTemplate.execute(sql.toString());
    }
}

