/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.OffsetDateTime;
import com.microsoft.sqlserver.jdbc.OffsetTime;
import com.microsoft.sqlserver.jdbc.SQLServerDataColumn;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import microsoft.sql.DateTimeOffset;

public final class SQLServerDataTable {
    int rowCount = 0;
    int columnCount = 0;
    Map<Integer, SQLServerDataColumn> columnMetadata = new LinkedHashMap<Integer, SQLServerDataColumn>();
    Map<Integer, Object[]> rows = new HashMap<Integer, Object[]>();

    public synchronized void clear() {
        this.rowCount = 0;
        this.columnCount = 0;
        this.columnMetadata.clear();
        this.rows.clear();
    }

    public synchronized Iterator<Map.Entry<Integer, Object[]>> getIterator() {
        if (null != this.rows && null != this.rows.entrySet()) {
            return this.rows.entrySet().iterator();
        }
        return null;
    }

    public synchronized void addColumnMetadata(String string, int n) throws SQLServerException {
        Util.checkDuplicateColumnName(string, this.columnMetadata);
        this.columnMetadata.put(this.columnCount++, new SQLServerDataColumn(string, n));
    }

    public synchronized void addColumnMetadata(SQLServerDataColumn sQLServerDataColumn) throws SQLServerException {
        Util.checkDuplicateColumnName(sQLServerDataColumn.columnName, this.columnMetadata);
        this.columnMetadata.put(this.columnCount++, sQLServerDataColumn);
    }

    public synchronized void addRow(Object ... objectArray) throws SQLServerException {
        try {
            int n = this.columnMetadata.size();
            if (null != objectArray && objectArray.length > n) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_moreDataInRowThanColumnInTVP"));
                Object[] objectArray2 = new Object[]{};
                throw new SQLServerException(null, messageFormat.format(objectArray2), null, 0, false);
            }
            Iterator<Map.Entry<Integer, SQLServerDataColumn>> iterator = this.columnMetadata.entrySet().iterator();
            Object[] objectArray3 = new Object[n];
            int n2 = 0;
            block17: while (iterator.hasNext()) {
                Object object = null;
                if (null != objectArray && n2 < objectArray.length && null != objectArray[n2]) {
                    object = null == objectArray[n2] ? null : objectArray[n2];
                }
                ++n2;
                Map.Entry<Integer, SQLServerDataColumn> entry = iterator.next();
                SQLServerDataColumn sQLServerDataColumn = entry.getValue();
                JDBCType jDBCType = JDBCType.of(entry.getValue().javaSqlType);
                boolean bl = false;
                switch (jDBCType) {
                    case BIGINT: {
                        objectArray3[entry.getKey().intValue()] = null == object ? null : Long.valueOf(Long.parseLong(object.toString()));
                        continue block17;
                    }
                    case BIT: {
                        objectArray3[entry.getKey().intValue()] = null == object ? null : Boolean.valueOf(Boolean.parseBoolean(object.toString()));
                        continue block17;
                    }
                    case INTEGER: {
                        objectArray3[entry.getKey().intValue()] = null == object ? null : Integer.valueOf(Integer.parseInt(object.toString()));
                        continue block17;
                    }
                    case SMALLINT: 
                    case TINYINT: {
                        objectArray3[entry.getKey().intValue()] = null == object ? null : Short.valueOf(Short.parseShort(object.toString()));
                        continue block17;
                    }
                    case DECIMAL: 
                    case NUMERIC: {
                        BigDecimal bigDecimal = null;
                        if (null != object) {
                            bigDecimal = new BigDecimal(object.toString());
                            if (bigDecimal.scale() > sQLServerDataColumn.scale) {
                                sQLServerDataColumn.scale = bigDecimal.scale();
                                bl = true;
                            }
                            if (bigDecimal.precision() > sQLServerDataColumn.precision) {
                                sQLServerDataColumn.precision = bigDecimal.precision();
                                bl = true;
                            }
                            if (bl) {
                                this.columnMetadata.put(entry.getKey(), sQLServerDataColumn);
                            }
                        }
                        objectArray3[entry.getKey().intValue()] = bigDecimal;
                        continue block17;
                    }
                    case DOUBLE: {
                        objectArray3[entry.getKey().intValue()] = null == object ? null : Double.valueOf(Double.parseDouble(object.toString()));
                        continue block17;
                    }
                    case FLOAT: 
                    case REAL: {
                        objectArray3[entry.getKey().intValue()] = null == object ? null : Float.valueOf(Float.parseFloat(object.toString()));
                        continue block17;
                    }
                    case TIMESTAMP_WITH_TIMEZONE: 
                    case TIME_WITH_TIMEZONE: {
                        DriverJDBCVersion.checkSupportsJDBC42();
                    }
                    case DATE: 
                    case TIME: 
                    case TIMESTAMP: 
                    case DATETIMEOFFSET: {
                        if (null == object) {
                            objectArray3[entry.getKey().intValue()] = null;
                            continue block17;
                        }
                        if (object instanceof Date) {
                            objectArray3[entry.getKey().intValue()] = ((Date)object).toString();
                            continue block17;
                        }
                        if (object instanceof DateTimeOffset) {
                            objectArray3[entry.getKey().intValue()] = ((DateTimeOffset)object).toString();
                            continue block17;
                        }
                        if (object instanceof OffsetDateTime) {
                            objectArray3[entry.getKey().intValue()] = ((OffsetDateTime)object).toString();
                            continue block17;
                        }
                        if (object instanceof OffsetTime) {
                            objectArray3[entry.getKey().intValue()] = ((OffsetTime)object).toString();
                            continue block17;
                        }
                        objectArray3[entry.getKey().intValue()] = null == object ? null : (String)object;
                        continue block17;
                    }
                    case BINARY: 
                    case VARBINARY: {
                        int n3;
                        boolean bl2 = null == object;
                        int n4 = n3 = bl2 ? 0 : ((byte[])object).length;
                        if (n3 > sQLServerDataColumn.precision) {
                            sQLServerDataColumn.precision = n3;
                            this.columnMetadata.put(entry.getKey(), sQLServerDataColumn);
                        }
                        objectArray3[entry.getKey().intValue()] = bl2 ? null : (byte[])object;
                        continue block17;
                    }
                    case CHAR: {
                        if (object instanceof UUID && object != null) {
                            object = ((UUID)object).toString();
                        }
                    }
                    case VARCHAR: 
                    case NCHAR: 
                    case NVARCHAR: {
                        int n3;
                        boolean bl2 = null == object;
                        int n5 = n3 = bl2 ? 0 : 2 * ((String)object).length();
                        if (n3 > sQLServerDataColumn.precision) {
                            sQLServerDataColumn.precision = n3;
                            this.columnMetadata.put(entry.getKey(), sQLServerDataColumn);
                        }
                        objectArray3[entry.getKey().intValue()] = bl2 ? null : (String)object;
                        continue block17;
                    }
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedDataTypeTVP"));
                Object[] objectArray4 = new Object[]{jDBCType};
                throw new SQLServerException(null, messageFormat.format(objectArray4), null, 0, false);
            }
            this.rows.put(this.rowCount++, objectArray3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), numberFormatException);
        }
        catch (ClassCastException classCastException) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), classCastException);
        }
    }

    public synchronized Map<Integer, SQLServerDataColumn> getColumnMetadata() {
        return this.columnMetadata;
    }
}

