var flag = true;
var checkboxStatus = 0;
var toolDatail  = new Array;
var warehouseData ;

var userId = $("#current_id").val();
var userName = $("#current_username").val();
var site = $("#current_site").val();
var titleName = $("#current_titleName").val();

//页面初始化
$(function(){
//	初始化批量录入
	InitCheckbox();
//	初始化录入时间
	InitStorageTime();
//	初始化光标
	$("#tool_detail").focus();	
});


//判断批量录入是否勾选
$("#bulk_entry").change(function(){
	flag =  $(this).is(':checked');
});

// 初始化入库日期
function InitStorageTime(){
	var data = getNowFormatDate();
	data = data.substring(0, 10);
	$("#storage_time").val(data);
}

// 初始化checkbox
function InitCheckbox(){
	$("#bulk_entry").attr("checked","checked");
	$("#add_entry").attr("checked","checked");
}

//设置增加事件
$("#add_entry").change(function(){
	var status = $(this).is(':checked');
	if(status){
		$("#del_entry").prop("checked",false);
		checkboxStatus = 0;
	}
});

//设置移除事件
$("#del_entry").change(function(){
	var status = $(this).is(':checked');
	if(status){
		$("#add_entry").prop("checked",false);
		checkboxStatus = 1;
	}
});

//为工具实例条码绑定一个失去焦点事件
$("#tool_detail").bind("keydown",function(event){
    if (event.keyCode == 13) {
    	var toolInstanceId = $(this).val();
    	if( checkboxStatus == 0){
        	if(null == toolInstanceId || toolInstanceId == ""){
        		layer.msg("工具实例条码不能为空!");
        	}else{
        		if(flag){
        			if(toolDatail.length > 0){
            			for (var i = 0; i < toolDatail.length; i++) {
            				if(toolDatail[i].toolInstanceId == toolInstanceId){
            					layer.msg("已有该工具记录!");
            					$("#tool_detail").val("");
            					return false;
            				}
            			}
            		}
        			getToolDatail(toolInstanceId);
        			$("#tool_detail").val("");
        		}else{
        			getToolDatail(toolInstanceId);
        			saveWareHouse();
        		}
        	}
    	}else{
    		if(toolDatail.length > 0){
    			for (var i = 0; i < toolDatail.length; i++) {
    				if(toolDatail[i].toolInstanceId == toolInstanceId){
    					toolDatailRemo(toolDatail[i].toolInstanceId);
    					toolDatail.splice(i,1);
    					layer.msg("移除成功!");
    					$("#tool_detail").val("");
    					return false;
    				}
    			}
    			layer.msg("没有该工具记录!");
				$("#tool_detail").val("");
				$("#tool_detail").focus();
    		}
    	}
    }
    return true;
});

// 获取获取工具实例编码
function getToolDatail(toolInstanceId){
	let jsonData = {
		toolInstanceId : toolInstanceId,
		site : site,
	}
	$.ajax({
		url: "/toolPda/getToolDetail",
		contentType: 'application/json',
		type:"POST",
		data:JSON.stringify(jsonData),//你的formid
		dataType:"JSON",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
        success: function (data) {
			var row = data.row;
			if(row != null && row != ""){
				if(row.status != "已投用"){
					layer.msg("该工具不为在库，不可报废!",{
						offset:['50%','15%'],
					});
					return false;
				}
				for (let i = 0; i < toolDatail.length; i++) {
					if(toolDatail[i].toolInstanceId == row.toolInstanceId){
						layer.msg("已有该工具记录!");
						$("#tool_detail").focus();
						return;
					}
				}
				toolDatail.push(row);
				var locationId="";	//放入显示的库位id
				if(row.locationId !=null){//如果当前库位是null，显示的库位id就设置成""
					locationId=row.locationId;
				}
				var str = '<tr id = '+row.toolInstanceId+'>' +
					'<th class="" style="text-align:center;background-color: #ffff;">' +
					'<span>'+row.toolInstanceId+'</span></th>' +
					'<th class="" style="text-align:center;background-color: #ffff;">' +
					'<span>'+row.toolDescription+'</span></th>' +
					'<th class="" style="text-align:center;background-color: #ffff;">' +
					'<span>'+locationId+'</span></th>' +
					'<th class="" style="text-align:center;background-color: #ffff;">' +
					'<button  data-toggle="modal" onclick="remove(\''+row.toolInstanceId+'\')" style="padding: 3px 10px;">' +
					'删除</button>'	+
					'</tr>';
				$("#dateil_table").append(str);
				layer.msg("添加成功!");
				$("#tool_detail").val("");
				$("#tool_detail").focus();
			}else{
				layer.msg("没有该工具记录!");
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.location.href="/login";
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}

//删除
function remove(id){
	if(toolDatail.length > 0){
		for (var i = 0; i < toolDatail.length; i++) {
			if(toolDatail[i].toolInstanceId == id){
				//toolDatailRemo(toolInstanceId);
				toolDatailRemo(toolDatail[i].toolInstanceId);
				toolDatail.splice(i,1);
				layer.msg("移除成功!");
				$("#tool_detail").val("");
				return false;
			}
		}
		layer.msg("没有该工具记录!");
		$("#tool_detail").val("");
	}
}

// 移除工具实例编码
function toolDatailRemo(id){
	$table=$("#dateil_table tr");
	$("tr[id='" + id + "']").remove();
}

//新增库位信息
function saveWareHouse(){
	var alreadyList = new Array;
	if(toolDatail.length == 0){
		layer.msg("请录入工具实例!");
		return false;
	}
	let remark = $('#remark').val()
	for(var i = 0; i< toolDatail.length; i++){
		jsonData = {
			toolId:toolDatail[i].toolId,
			site:toolDatail[i].site,
			toolInstanceId:toolDatail[i].toolInstanceId,
			transNoHead : "TB",
			transType : "工具报废",
			transTypeDb : "B",
			direction : "-",
			status: "已报废",
			locationId : '',
			statusRef: "报废",
			userName :userName,
			remark :remark,
		};
		alreadyList.push(jsonData);
	}
	$.ajax({
		url: "/toolPda/updateToolDetail",
		contentType: 'application/json',
		type:"POST",
		data:JSON.stringify(alreadyList),
		dataType:"JSON",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
        success: function (data) {
        	if(data.code == 0){
        		toolDatail = new Array;
        		layer.msg(data.msg);
        		$("#dateil_table").html("");
    			$("#tool_detail").val("");
				$('#remark').val('')
        	}else if(data.code == 401){
				window.location.href="/login";
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.location.href="/login";
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}

function cleanData(){
	toolDatail = new Array;
	$("#dateil_table").html("");
}
