/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaotao.common.exception.XJException;
import com.gaotao.common.utils.PageUtils;
import com.gaotao.common.utils.Query;
import com.gaotao.modules.sys.dao.SysRoleDao;
import com.gaotao.modules.sys.dao.SysUserDao;
import com.gaotao.modules.sys.entity.SysUserEntity;
import com.gaotao.modules.sys.service.SysMsgService;
import com.gaotao.modules.sys.service.SysUserRoleService;
import com.gaotao.modules.sys.service.SysUserService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUserService")
public class SysUserServiceImpl
extends ServiceImpl<SysUserDao, SysUserEntity>
implements SysUserService {
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysRoleDao sysRoleDao;
    @Autowired
    private SysMsgService sysMsgService;

    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        String username = (String)params.get("username");
        Long createUserId = (Long)params.get("createUserId");
        IPage page = this.page(new Query().getPage(params), (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().like(StringUtils.isNotBlank((String)username), (Object)"username", (Object)username)).eq(createUserId != null, (Object)"create_user_id", (Object)createUserId)).orderByAsc((Object)"username"));
        return new PageUtils(page);
    }

    @Override
    public List<String> queryAllPerms(Long userId) {
        return ((SysUserDao)this.baseMapper).queryAllPerms(userId);
    }

    @Override
    public List<String> queryAllMenuId(Long userId) {
        return ((SysUserDao)this.baseMapper).queryAllMenuId(userId);
    }

    @Override
    public SysUserEntity queryByUserName(String username) {
        return ((SysUserDao)this.baseMapper).queryByUserName(username);
    }

    @Override
    @Transactional
    public void saveUser(SysUserEntity user) {
        user.setCreateTime(new Date());
        String salt = RandomStringUtils.randomAlphanumeric((int)20);
        user.setPassword(new Sha256Hash((Object)user.getPassword(), (Object)salt).toHex());
        user.setSalt(salt);
        this.save(user);
        this.checkRole(user);
        this.sysUserRoleService.saveOrUpdate(user.getUserId(), user.getRoleIdList());
    }

    @Override
    @Transactional
    public void update(SysUserEntity user) {
        if (StringUtils.isBlank((String)user.getPassword())) {
            user.setPassword(null);
        } else {
            user.setPassword(new Sha256Hash((Object)user.getPassword(), (Object)user.getSalt()).toHex());
        }
        this.updateById(user);
        this.checkRole(user);
        this.sysUserRoleService.saveOrUpdate(user.getUserId(), user.getRoleIdList());
    }

    @Override
    public void deleteBatch(Long[] userId) {
        this.removeByIds(Arrays.asList(userId));
    }

    @Override
    public boolean updatePassword(Long userId, String password, String newPassword) {
        SysUserEntity userEntity = new SysUserEntity();
        userEntity.setPassword(newPassword);
        return this.update(userEntity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).eq((Object)"password", (Object)password));
    }

    private void checkRole(SysUserEntity user) {
        if (user.getRoleIdList() == null || user.getRoleIdList().size() == 0) {
            return;
        }
        if (user.getCreateUserId() == 1L) {
            return;
        }
        List<Long> roleIdList = this.sysRoleDao.queryRoleIdList(user.getCreateUserId());
        if (!roleIdList.containsAll(user.getRoleIdList())) {
            throw new XJException(this.sysMsgService.getLanguageMsg("200221"));
        }
    }

    @Override
    public void updateUserLanguageDefault(SysUserEntity userEntity) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(userEntity.getLanguageDefault() != null, SysUserEntity::getLanguageDefault, (Object)userEntity.getLanguageDefault())).eq(userEntity.getUserId() != null, SysUserEntity::getUserId, (Object)userEntity.getUserId())).update();
    }

    @Override
    public List<SysUserEntity> userList(SysUserEntity params) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SysUserEntity::getSite, (Object)params.getSite())).eq(SysUserEntity::getStatus, (Object)params.getStatus())).orderBy(true, true, SysUserEntity::getUsername)).list();
    }
}

