/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.controller;

import com.gaotao.common.annotation.SysLog;
import com.gaotao.common.utils.PageUtils;
import com.gaotao.common.utils.R;
import com.gaotao.common.validator.ValidatorUtils;
import com.gaotao.modules.sys.controller.AbstractController;
import com.gaotao.modules.sys.entity.SysRoleEntity;
import com.gaotao.modules.sys.service.SysRoleMenuService;
import com.gaotao.modules.sys.service.SysRoleService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/role"})
public class SysRoleController
extends AbstractController {
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;

    @GetMapping(value={"/list"})
    public R list(@RequestParam Map<String, Object> params) {
        if (this.getUserId() != 1L) {
            params.put("createUserId", this.getUserId());
        }
        PageUtils page = this.sysRoleService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @GetMapping(value={"/select"})
    public R select() {
        HashMap map = new HashMap();
        List list = this.sysRoleService.listByMap(map);
        return R.ok().put("list", (Object)list);
    }

    @GetMapping(value={"/info/{roleId}"})
    public R info(@PathVariable(value="roleId") Long roleId) {
        SysRoleEntity role = (SysRoleEntity)this.sysRoleService.getById(roleId);
        List<String> menuIdList = this.sysRoleMenuService.queryMenuIdList(roleId);
        role.setMenuIdList(menuIdList);
        return R.ok().put("role", (Object)role);
    }

    @SysLog(value="\u4fdd\u5b58\u89d2\u8272")
    @PostMapping(value={"/save"})
    public R save(@RequestBody SysRoleEntity role) {
        ValidatorUtils.validateEntity(role, new Class[0]);
        role.setCreateUserId(this.getUserId());
        this.sysRoleService.saveRole(role);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @SysLog(value="\u4fee\u6539\u89d2\u8272")
    @PostMapping(value={"/update"})
    public R update(@RequestBody SysRoleEntity role) {
        ValidatorUtils.validateEntity(role, new Class[0]);
        role.setCreateUserId(this.getUserId());
        this.sysRoleService.update(role);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @SysLog(value="\u5220\u9664\u89d2\u8272")
    @PostMapping(value={"/delete"})
    public R delete(@RequestBody Long[] roleIds) {
        this.sysRoleService.deleteBatch(roleIds);
        return R.ok(this.getLanguageMsg("200000"));
    }
}

