/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.controller;

import com.gaotao.common.annotation.SysLog;
import com.gaotao.common.utils.PageUtils;
import com.gaotao.common.utils.R;
import com.gaotao.common.validator.ValidatorUtils;
import com.gaotao.modules.sys.controller.AbstractController;
import com.gaotao.modules.sys.entity.SysConfigEntity;
import com.gaotao.modules.sys.service.SysConfigService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/config"})
public class SysConfigController
extends AbstractController {
    @Autowired
    private SysConfigService sysConfigService;

    @GetMapping(value={"/list"})
    public R list(@RequestParam Map<String, Object> params) {
        PageUtils page = this.sysConfigService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @GetMapping(value={"/info/{id}"})
    public R info(@PathVariable(value="id") Long id) {
        SysConfigEntity config = (SysConfigEntity)this.sysConfigService.getById(id);
        return R.ok().put("config", (Object)config);
    }

    @SysLog(value="\u4fdd\u5b58\u914d\u7f6e")
    @PostMapping(value={"/save"})
    public R save(@RequestBody SysConfigEntity config) {
        ValidatorUtils.validateEntity(config, new Class[0]);
        this.sysConfigService.saveConfig(config);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @SysLog(value="\u4fee\u6539\u914d\u7f6e")
    @PostMapping(value={"/update"})
    public R update(@RequestBody SysConfigEntity config) {
        ValidatorUtils.validateEntity(config, new Class[0]);
        this.sysConfigService.update(config);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @SysLog(value="\u5220\u9664\u914d\u7f6e")
    @PostMapping(value={"/delete"})
    public R delete(@RequestBody Long[] ids) {
        this.sysConfigService.deleteBatch(ids);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @PostMapping(value={"getConfigParams"})
    public R getConfigParams() {
        Map<String, Object> configParams = this.sysConfigService.getConfigParams();
        return R.ok().put("data", (Object)configParams);
    }
}

