/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.report.dao.impl;

import com.gaotao.modules.report.dao.CmchReportDao;
import com.gaotao.modules.report.data.TidBindInfoData;
import com.gaotao.modules.report.data.WaferTableHist;
import com.gaotao.modules.report.model.PartitionTableRules;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class CmchReportDaoImpl
implements CmchReportDao {
    @Autowired
    private NamedParameterJdbcTemplate parameterJdbcTemplate;

    @Override
    public List<WaferTableHist> getWaferTableHist(String site, String waferId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT id, site, wafer_id, file_name, wafer_manufacturer, wafer_type,");
        sql.append(" first_part, second_part, third_part, count_nums, table_name, status, remark,");
        sql.append(" created_by, created_date, updated_by, updated_date, bind_nums");
        sql.append(" FROM tid_wafer_table_hist twf");
        sql.append(" WHERE twf.wafer_id = :waferId");
        paramMap.put("waferId", waferId);
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(WaferTableHist.class));
    }

    @Override
    public PartitionTableRules getPartitionTableRules(String chipModel) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT id, chip_vendor_device_no, part_first_start, part_first_lens, diff_type,");
        sql.append(" part_second_start, part_second_lens, part_third_start, part_third_lens, remark");
        sql.append(" FROM partition_table_rules");
        sql.append(" WHERE chip_vendor_device_no = :chipModel");
        paramMap.put("chipModel", chipModel);
        List resultList = this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(PartitionTableRules.class));
        if (resultList.size() > 0) {
            return (PartitionTableRules)resultList.get(0);
        }
        return null;
    }

    @Override
    public List<TidBindInfoData> getTidBindInfos(String tableName, String tid) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT tp.tid, tp.wafer_id");
        sql.append(" FROM " + tableName + " tp");
        sql.append(" WHERE tp.tid = :tid");
        paramMap.put("tid", tid);
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(TidBindInfoData.class));
    }

    @Override
    public PartitionTableRules getPartitionTableRules(String chipModel, int charLength) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT id, chip_vendor_device_no, part_first_start, part_first_lens, diff_type,");
        sql.append(" part_second_start, part_second_lens, part_third_start, part_third_lens, remark");
        sql.append(" FROM partition_table_rules");
        sql.append(" WHERE chip_vendor_device_no = :chipModel AND char_length = :charLength");
        paramMap.put("chipModel", chipModel);
        paramMap.put("charLength", charLength);
        List resultList = this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(PartitionTableRules.class));
        if (resultList.size() > 0) {
            return (PartitionTableRules)resultList.get(0);
        }
        return null;
    }

    @Override
    public TidBindInfoData getTidWaferInfo(String tableName, String tid) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        sql.append("SELECT tp.tid, tp.wafer_id");
        sql.append(" FROM " + tableName + " tp");
        sql.append(" WHERE tp.tid = :tid");
        paramMap.put("tid", tid);
        List resultList = this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(TidBindInfoData.class));
        if (resultList.size() > 0) {
            return (TidBindInfoData)resultList.get(0);
        }
        return null;
    }
}

