/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.common.batch;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import com.gaotao.common.batch.NoahSqlMethod;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;

public class InsertBatch
extends AbstractMethod {
    private static final long serialVersionUID = -6199780584528192701L;
    private static final String LEFT_BRACKET = "(";
    private static final String RIGHT_BRACKET = ")";
    private static final String COMMA = ",";

    public InsertBatch() {
        super("insertBatch");
    }

    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        MapperBuilderAssistant builderAssistant = this.builderAssistant;
        Configuration configuration = builderAssistant.getConfiguration();
        NoKeyGenerator keyGenerator = new NoKeyGenerator();
        String columnScript = SqlScriptUtils.convertTrim((String)tableInfo.getKeyInsertSqlColumn(false, null, false), (String)LEFT_BRACKET, (String)RIGHT_BRACKET, null, (String)COMMA);
        String valuesScript = SqlScriptUtils.convertTrim((String)tableInfo.getKeyInsertSqlProperty(false, null, false), (String)LEFT_BRACKET, (String)RIGHT_BRACKET, null, (String)COMMA);
        String keyProperty = null;
        String keyColumn = null;
        if (StringUtils.isNotEmpty((CharSequence)tableInfo.getKeyProperty())) {
            IdType idType = tableInfo.getIdType();
            if (idType == IdType.AUTO) {
                keyGenerator = new Jdbc3KeyGenerator();
                keyProperty = tableInfo.getKeyProperty();
                keyColumn = tableInfo.getKeyColumn();
            } else if (idType == IdType.ASSIGN_ID || idType == IdType.ASSIGN_UUID) {
                keyGenerator = new NoKeyGenerator();
                keyProperty = tableInfo.getKeyProperty();
                keyColumn = tableInfo.getKeyColumn();
            } else if (idType == IdType.INPUT) {
                keyGenerator = new NoKeyGenerator();
                keyProperty = tableInfo.getKeyProperty();
                keyColumn = tableInfo.getKeyColumn();
            } else if (idType == IdType.NONE) {
                keyGenerator = new NoKeyGenerator();
            }
        }
        NoahSqlMethod sqlMethod = NoahSqlMethod.INSERT_BATCH;
        String sql = String.format(sqlMethod.getSql(), tableInfo.getTableName(), columnScript, valuesScript);
        SqlSource sqlSource = this.languageDriver.createSqlSource(configuration, sql, modelClass);
        return this.addInsertMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource, (KeyGenerator)keyGenerator, keyProperty, keyColumn);
    }
}

