/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSecurityUtility;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKey;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;

class SQLServerAeadAes256CbcHmac256EncryptionKey
extends SQLServerSymmetricKey {
    static final int keySize = 256;
    private final String algorithmName;
    private String encryptionKeySaltFormat;
    private String macKeySaltFormat;
    private String ivKeySaltFormat;
    private SQLServerSymmetricKey encryptionKey;
    private SQLServerSymmetricKey macKey;
    private SQLServerSymmetricKey ivKey;

    SQLServerAeadAes256CbcHmac256EncryptionKey(byte[] byArray, String string) throws SQLServerException {
        super(byArray);
        this.algorithmName = string;
        this.encryptionKeySaltFormat = "Microsoft SQL Server cell encryption key with encryption algorithm:" + this.algorithmName + " and key length:" + 256;
        this.macKeySaltFormat = "Microsoft SQL Server cell MAC key with encryption algorithm:" + this.algorithmName + " and key length:" + 256;
        this.ivKeySaltFormat = "Microsoft SQL Server cell IV key with encryption algorithm:" + this.algorithmName + " and key length:" + 256;
        int n = 32;
        if (byArray.length != n) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidKeySize"));
            Object[] objectArray = new Object[]{byArray.length, n, this.algorithmName};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        byte[] byArray2 = new byte[n];
        try {
            byArray2 = SQLServerSecurityUtility.getHMACWithSHA256(this.encryptionKeySaltFormat.getBytes("UTF-16LE"), byArray, byArray2.length);
            this.encryptionKey = new SQLServerSymmetricKey(byArray2);
            byte[] byArray3 = new byte[n];
            byArray3 = SQLServerSecurityUtility.getHMACWithSHA256(this.macKeySaltFormat.getBytes("UTF-16LE"), byArray, byArray3.length);
            this.macKey = new SQLServerSymmetricKey(byArray3);
            byte[] byArray4 = new byte[n];
            byArray4 = SQLServerSecurityUtility.getHMACWithSHA256(this.ivKeySaltFormat.getBytes("UTF-16LE"), byArray, byArray4.length);
            this.ivKey = new SQLServerSymmetricKey(byArray4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
            Object[] objectArray = new Object[]{"UTF-16LE"};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_KeyExtractionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
    }

    byte[] getEncryptionKey() {
        return this.encryptionKey.getRootKey();
    }

    byte[] getMacKey() {
        return this.macKey.getRootKey();
    }

    byte[] getIVKey() {
        return this.ivKey.getRootKey();
    }
}

