// 页面初始化加在数据
$(function () {
    getSupplier()
});

// 拆分 供应商编号 供应商ID
function getSupplier() {
    var item = localStorage.getItem("supplier");
    let supplierId = item.split("|")[0]
    let supplierName = item.split("|")[0]
    $('#supplier').val(item)
    $('#supplierId').val(supplierId)
    $('#supplierName').val(supplierName)


}

//为内部卷号绑定一个失去焦点事件
$("#rollNo").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var rollNo = $("#rollNo").val();
        if (null == rollNo || rollNo == "") {
            layer.alert("卷号不能为空!");
        } else {
            scanRollNo(rollNo);
            return false;
        }
    }
    return true;
});
let rolls = []

// 通过内部卷号获取信息
function scanRollNo(rollNo) {
    let dto = {
        rollno: rollNo,
        site: $('#current_site').val(),
        supplierid: $('#supplierId').val()
    }
    $.ajax({
        url: "/purchaseReturn/scanRollNo",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(dto),//你的formid
        dataType: "JSON",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            var code = data.code;
            var rollInfo = data.data;
            if (code == 0) {
                // 是否已扫描
                let find = rolls.filter(item => item.rollno == rollInfo.rollno);
                if (find.length>0){
                    layer.alert('该卷已扫描!')
                    return
                }
                rolls.push(rollInfo)
                let str = '<tr>' +
                    '<th class="" >' +
                    '<button  data-toggle="modal" onclick="removerRoll(\'' + rollInfo.rollno + '\')" style="padding: 3px 10px;">' +
                    '删除</button>' +
                    '<th class="" >' +
                    '<span>' + rollInfo.rollno + '</span></th>' +
                    '<th class="" >' +
                    '<span>' + rollInfo.rollqty + '</span></th>' +
                    '</tr>';
                $("#roll_table").append(str);
            } else if (code == 500) {
                layer.alert(data.msg);
            }
            $("#rollNo").val('');
        },
        error: function (data) {

        }
    });
}

// 删除扫描的卷
function removerRoll(rollNo){
    rolls = rolls.filter( item => item.rollno != rollNo)
    $("#roll_table").html('');
    let str = ''
    for (let i = 0; i < rolls.length; i++) {
        let rollInfo = rolls[i]
        str = '<tr>' +
            '<th class="" >' +
            '<button  data-toggle="modal" onclick="removerRoll(\'' + rollInfo.rollno + '\')" style="padding: 3px 10px;">' +
            '删除</button>' +
            '<th class="" >' +
            '<span>' + rollInfo.rollno + '</span></th>' +
            '<th class="" >' +
            '<span>' + rollInfo.rollqty + '</span></th>' +
            '</tr>';
    }
    $("#roll_table").html(str);
}

// 结束当前扫描操作
function returnGoods() {
    if (rolls.length==0){
        layer.alert('请扫描退货的卷')
        return;
    }
    layer.confirm('确定退货？', {
        btn : [ '确认', '取消' ]
        // 按钮
    }, function() {
        layer.closeAll('dialog');
        $.ajax({
            url: "/purchaseReturn/returnGoods",
            type: "POST",
            contentType: 'application/json',
            data: JSON.stringify(rolls),
            dataType: "json",
            beforeSend: function (request) {
                request.setRequestHeader("token", $.cookie("token"));
            },
            success: function (data) {
                var code = data.code;
                if (code == 0) {
                    layer.confirm(data.msg+', 是否返回上级-选择供应商', {
                        btn: ['确认', '取消']
                        // 按钮
                    }, function () {
                        layer.closeAll('dialog');
                        window.document.location.href = "/pda/purchaseSupplier"
                    }, function () {
                        window.document.location.href = "/pda/purchaseReturn"
                    });
                } else {
                    layer.alert(data.msg);
                }
            },
            error: function (data) {
                layer.alert(data.msg);
            }
        });
    }, function() {
        layer.closeAll('dialog');
    });

}

// 返回主界面清除缓存信息
function goBack() {
    layer.confirm("返回上级菜单,将会删除当前扫描信息！！", {
        btn: ['确认', '取消']
        // 按钮
    }, function () {
        layer.closeAll('dialog');
        window.document.location.href = "/pda/purchaseSupplier"
    }, function () {
        layer.closeAll('dialog');
    });
}

// 清楚信息
function clear() {
    $("#rollNo").val("");
}