//为内部卷号绑定一个失去焦点事件
$("#rollNo").bind("keydown",function(event){
          if (event.keyCode == 13) {
        	  var rollNo = $.trim($("#rollNo").val());
        	  if(null==rollNo||rollNo==""){
        		  layer.alert("卷号不能为空!");
        	  }else{
        		  scanRollNo(rollNo);
                  return false;
        	  }
          }
          return true;
});
// 页面初始化加在数据
$(function(){
	// 判断是否需要更新当前页面数
	var flag = $("#flag").val();
	// 判断是否开始收货
	if(flag == 'Y'){
		getSaveRollInfo();
	}
});

// 通过内部卷号获取信息
function scanRollNo(rollNo){
	$.ajax({
		url : "/inventory/scanRollNo",
		type : "POST",
		data : {rollNo: rollNo},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			var tempData = data.obj;
			if (code=='200') {
				// 刷新页面
				window.document.location.href = "/pda/inventoryCheck";
			}else{
				$("#rollNo").val("");
				$("#rollNo").focus();
				layer.alert(data.msg);
			}
		},
		error : function(data) {
		}
	});
}

// 刷新记录信息
function getSaveRollInfo(){
	$.ajax({
		url : "/inventory/getSaveRollInfo",
		type : "POST",
		data : {},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var tagStr ='';
			tagStr+='<div class="ivu-table-wrapper"><div class="ivu-table">';
			tagStr+='<div class="ivu-table-header">';
			tagStr+='<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">';
			tagStr+='<colgroup><col width="80"><col width="85"><col width="65"><col width="80"></colgroup>';
			tagStr+='<thead><tr>';
			tagStr+='<th class=""><div class="ivu-table-cell"><span>卷号</span></div></th>';
			tagStr+='<th class=""><div class="ivu-table-cell"><span>物料描述</span></div></th>';
			tagStr+='<th class=""><div class="ivu-table-cell"><span>数量</span></div></th>';
			tagStr+='<th class=""><div class="ivu-table-cell"><span>操作</span></div></th>';
			tagStr+='</tr></thead></table></div>';
			tagStr+='<div class="ivu-table-body">';
			tagStr+='<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">';
			tagStr+='<colgroup><col width="80"><col width="85"><col width="65"><col width="80"></colgroup>';
			tagStr+='<tbody class="ivu-table-tbody">';
			var obj = data.obj;
			for(var i = 0; i< obj.length; i++){
				var rollData = obj[i];
				tagStr+='<tr class="ivu-table-row"><td class=""><div class="ivu-table-cell"><span>'+rollData.rollNo+'</span></div></td>';
				tagStr+='<td class=""><div class="ivu-table-cell"><span>'+rollData.partDes+'</span></div></td>';
				tagStr+='<td class=""><div class="ivu-table-cell"><span>'+rollData.rollQty+'</span></div></td>';
				tagStr+='<td class=""><div class="ivu-table-cell"><div>';
				tagStr+='<button type="button" onclick="delRollNos('+'\''+rollData.rollNo+'\''+')"'+' class="ivu-btn ivu-btn-error ivu-btn-small"><span>删除</span></button>';
				tagStr+='</div></div></td></tr>';
				}
			tagStr+='</tbody></table></div></div></div></div>';
			$("#rollCounts").append(tagStr);
		},
		error : function(data) {
		}
	});
}

// 结束扫描生成excel
function endScan(){
	// 判断是否已经开启扫描
	var flag = $("#flag").val();
	if(flag=='Y'){
		layer.confirm('确认完成扫描？', {
			btn : [ '确认', '取消' ]
		// 按钮
		}, function() {
			layer.closeAll('dialog');
			endCurrentScan();
		}, function() {
			clear();
			$("#rollNo").focus();
		});
	}else{
		layer.alert("当前暂无已扫描的卷号！");
	}
}

//删除卷信息数据(包含缓存的数据)
function delRollNos(rollNo){
	$.ajax({
		url : "/inventory/delRollNos",
		type : "POST",
		data : {"rollNo": rollNo},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				layer.confirm(data.msg, {
					btn : [ '确认', '取消' ]
				// 按钮
				}, function() {
					layer.closeAll('dialog');
					window.document.location.href="/pda/inventoryCheck"
				}, function() {
					layer.closeAll('dialog');
					window.document.location.href="/pda/inventoryCheck"
				});
			}else if(code=='500'){
				layer.confirm(data.msg, {
					btn : [ '确认', '取消' ]
				// 按钮
				}, function() {
					layer.closeAll('dialog');
				}, function() {
					layer.closeAll('dialog');
				});
			}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}



// 结束当前扫描操作
function endCurrentScan(){
	$.ajax({
		url : "/inventory/endCurrentScan",
		type : "POST",
		data : {},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				layer.confirm(data.msg, {
					btn : [ '确认', '取消' ]
				// 按钮
				}, function() {
					layer.closeAll('dialog');
					window.document.location.href="/pda/inventoryCheck"
				}, function() {
					layer.closeAll('dialog');
					window.document.location.href="/pda/inventoryCheck"
				});
			}else if(code=='500'){
				layer.confirm(data.msg, {
					btn : [ '确认', '取消' ]
				// 按钮
				}, function() {
					layer.closeAll('dialog');
				}, function() {
					layer.closeAll('dialog');
				});
			}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}
// 返回主界面清除缓存信息
function goBack(){
	layer.confirm("返回主界面将会删除当前扫描信息！！", {
		btn : [ '确认', '取消' ]
	// 按钮
	}, function() {
		layer.closeAll('dialog');
		goBackHome();
	}, function() {
		layer.closeAll('dialog');
	});
}
// 执行返回主界面清除缓存信息
function goBackHome(){
	var token ={
		"token":$.cookie("token")
	}
	$.ajax({
		url : "/inventory/goBackHome",
		type : "POST",
		data : token,
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				window.location.href = "/pda/publicMenu?titleName=''&menuId=0";
		}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}
// 清楚信息
function clear(){
	$("#rollNo").val("");
}