//为内部卷号绑定一个失去焦点事件
$("#rollNo").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var rollNo = $("#rollNo").val();
        if (null == rollNo || rollNo == "") {
            layer.alert("内部卷号不能为空!");
        } else {
            scanRollNo(rollNo);
            return false;
        }
    }
    return true;
});
// 页面初始化加在数据
$(function () {
    // 判断是否需要更新当前页面数
    var flag = $("#flag").val();
    // 判断是否开始收货
    if (flag == 'Y') {
        getSavedRollCounts();
    }
});

// 通过内部卷号获取信息
function scanRollNo(rollNo) {
    let wid = $('#partNo').val()
    $.ajax({
        url: "/dump/scanRollNo",
        type: "POST",
        data: {rollNo: rollNo,warehouseId:wid},
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            var code = data.code;
            var tempData = data.obj;
            if (code == '0') {
                // 刷新页面
                window.document.location.href = "/pda/dump/dumpPage";
                // 更新供应商编码
            } else if (code == '1') {
                layer.alert(data.msg);
                $("#rollNo").val("");
            }
        },
        error: function (data) {
        }
    });
}

// 刷新记录信息
function getSavedRollCounts() {
    $.ajax({
        url: "/dump/getSavedRollCounts",
        type: "POST",
        data: {},
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            var tagStr = '';
            for (key in data) {
                var partNo = data[key].partNo;
                tagStr += '<div><div class="r-left-line">物料描述：' + data[key].partDes + '</div>';
                tagStr += '<div class="ivu-table-wrapper"><div class="ivu-table">';
                tagStr += '<div class="ivu-table-header">';
                tagStr += '<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">';
                tagStr += '<colgroup><col width="90"><col width="60"><col width="75"><col width="80"></colgroup>';
                tagStr += '<thead><tr><th class=""><div class="ivu-table-cell">';
                tagStr += '<span>单卷数量</span></div></th>';
                tagStr += '<th class=""><div class="ivu-table-cell"><span>卷数</span></div></th>';
                tagStr += '<th class=""><div class="ivu-table-cell"><span>总数量</span></div></th>';
                tagStr += '<th class=""><div class="ivu-table-cell"><span>操作</span></div></th>';
                tagStr += '</tr></thead></table></div>';
                tagStr += '<div class="ivu-table-body">';
                tagStr += '<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">';
                tagStr += '<colgroup><col width="90"><col width="60"><col width="75"><col width="80"></colgroup>';
                tagStr += '<tbody class="ivu-table-tbody">';
                var rollData = data[key].list;
                for (inKey in rollData) {
                    tagStr += '<tr class="ivu-table-row"><td class=""><div class="ivu-table-cell"><span>' + rollData[inKey].nums + '</span></div></td>';
                    tagStr += '<td class=""><div class="ivu-table-cell"><span>' + rollData[inKey].rollNums + '</span></div></td>';
                    tagStr += '<td class=""><div class="ivu-table-cell"><span>' + rollData[inKey].rollTotal + '</span></div></td>';
                    tagStr += '<td class=""><div class="ivu-table-cell"><div>';
                    tagStr += '<button type="button" onclick="getRollNos(' + '\'' + partNo + '\',' + rollData[inKey].nums + ')"' + ' class="ivu-btn ivu-btn-primary ivu-btn-small"><span>明细</span></button>';
                    tagStr += '</div></div></td></tr>';
                }
                tagStr += '</tbody></table></div></div></div></div>';
            }
            $("#rollCounts").append(tagStr);
        },
        error: function (data) {
        }
    });
}

// 获取参数并且页面跳转
function getRollNos(partNo, nums) {
    $.ajax({
        url: "/dump/sendRollParamter",
        type: "POST",
        data: {partNo: partNo, nums: nums},
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            var code = data.code;
            if (code == '0') {
                window.document.location.href = "/pda/dump/dumpRolls"
            } else {
                layer.alert(data.msg);
            }
        },
        error: function (data) {
            layer.alert(data.msg);
        }
    });
}

// 结束扫描
function endScan() {
    // 判断是否已经开启扫描
    var flag = $("#flag").val();
    if (flag == 'Y') {
        layer.confirm('确认完成扫描？', {
            btn: ['确认', '取消']
            // 按钮
        }, function () {
            layer.closeAll('dialog');
            endCurrentScan();
        }, function () {
            clear();
            $("#rollNo").focus();
        });
    } else {
        layer.alert("当前暂无已扫描的卷号！");
    }
}

// 结束当前扫描操作
function endCurrentScan() {
    $.ajax({
        url: "/dump/endCurrentScan",
        type: "POST",
        data: {"depot": $("#dump_to").val(), "orderNo": $('#orderNo').val()},
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            var code = data.code;
            if (code == '0') {
                layer.confirm('打印转储订单', {
                    btn: ['确认', '取消']
                    // 按钮
                }, () => {
                    $("#iframe_for_print").attr("src", '/pda/print/dump');
					setTimeout(`console.log("打印转储订单")`, 1000)
                    layer.confirm(data.msg, {
                        btn: ['确认', '取消']
                        // 按钮
                    }, function () {
                        layer.closeAll('dialog');
                        window.document.location.href = "/pda/publicMenu?titleName=''&menuId=0"
                    }, function () {
                        layer.closeAll('dialog');
                        window.document.location.href = "/pda/publicMenu?titleName=''&menuId=0"
                    });
                }, () => {
                    layer.confirm(data.msg, {
                        btn: ['确认', '取消']
                        // 按钮
                    }, function () {
                        layer.closeAll('dialog');
                        window.document.location.href = "/pda/publicMenu?titleName=''&menuId=0"
                    }, function () {
                        layer.closeAll('dialog');
                        window.document.location.href = "/pda/publicMenu?titleName=''&menuId=0"
                    });
                })


            } else if (code == '1') {
                layer.confirm(data.msg, {
                    btn: ['确认', '取消']
                    // 按钮
                }, function () {
                    layer.closeAll('dialog');
                }, function () {
                    layer.closeAll('dialog');
                });
            } else {
                var outData = data.obj;
                var outShow = '状态有误的卷号：';
                for (var i = 0; i < outData.length; i++) {
                    outShow += outData[i];
                }
                layer.alert(outShow);
            }
        },
        error: function (data) {
            layer.alert(data.msg);
        }
    });
}

// 返回主界面清除缓存信息
function goBack() {
    layer.confirm("返回主界面将会删除当前扫描信息！！", {
        btn: ['确认', '取消']
        // 按钮
    }, function () {
        layer.closeAll('dialog');
        goBackHome();
    }, function () {
        layer.closeAll('dialog');
    });
}

// 执行返回主界面清除缓存信息
function goBackHome() {
    var token = {
        "token": $.cookie("token")
    }
    $.ajax({
        url: "/dump/goBackHome",
        type: "POST",
        data: token,
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            var code = data.code;
            if (code == '0') {
                window.location.href = "/pda/publicMenu?titleName=''&menuId=0";
            }
        },
        error: function (data) {
            layer.msg(data.msg);
        }
    });
}

// 清楚信息
function clear() {
    $("#rollNo").val("");
}