/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaotao.common.exception.XJException;
import com.gaotao.common.utils.PageUtils;
import com.gaotao.common.utils.Query;
import com.gaotao.modules.sys.dao.SysConfigDao;
import com.gaotao.modules.sys.entity.SysConfigEntity;
import com.gaotao.modules.sys.redis.SysConfigRedis;
import com.gaotao.modules.sys.service.SysConfigService;
import com.gaotao.modules.sys.service.SysMsgService;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysConfigService")
public class SysConfigServiceImpl
extends ServiceImpl<SysConfigDao, SysConfigEntity>
implements SysConfigService {
    @Autowired
    private SysConfigRedis sysConfigRedis;
    @Autowired
    private SysMsgService sysMsgService;

    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        String paramKey = (String)params.get("paramKey");
        IPage page = this.page(new Query().getPage(params), (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().like(StringUtils.isNotBlank((String)paramKey), (Object)"param_key", (Object)paramKey)).ne((Object)"status", (Object)0)).orderByAsc((Object)"param_key"));
        return new PageUtils(page);
    }

    @Override
    public void saveConfig(SysConfigEntity config) {
        this.save(config);
        this.sysConfigRedis.saveOrUpdate(config);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SysConfigEntity config) {
        this.updateById(config);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateValueByKey(String key, String value) {
        ((SysConfigDao)this.baseMapper).updateValueByKey(key, value);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(Long[] ids) {
        for (Long id : ids) {
            SysConfigEntity sysConfigEntity = (SysConfigEntity)this.getById(id);
        }
        this.removeByIds(Arrays.asList(ids));
    }

    @Override
    public String getValue(String key) {
        SysConfigEntity config = ((SysConfigDao)this.baseMapper).queryByKey(key);
        return config == null ? null : config.getParamValue();
    }

    @Override
    public <T> T getConfigObject(String key, Class<T> clazz) {
        String value = this.getValue(key);
        if (StringUtils.isNotBlank((String)value)) {
            return (T)new Gson().fromJson(value, clazz);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new XJException(this.sysMsgService.getLanguageMsg("200219"));
        }
    }

    @Override
    public Map<String, Object> getConfigParams() {
        List configEntityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SysConfigEntity::getStatus, (Object)2)).list();
        Map<String, Object> configParaMap = configEntityList.stream().collect(Collectors.toMap(SysConfigEntity::getParamKey, SysConfigEntity::getParamValue));
        return configParaMap;
    }
}

