/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.controller;

import com.gaotao.common.annotation.SysLog;
import com.gaotao.common.exception.XJException;
import com.gaotao.common.utils.Constant;
import com.gaotao.common.utils.R;
import com.gaotao.modules.sys.controller.AbstractController;
import com.gaotao.modules.sys.entity.SysMenuEntity;
import com.gaotao.modules.sys.entity.SysObjectLanguageMenu;
import com.gaotao.modules.sys.entity.dto.SysMenuEntityDto;
import com.gaotao.modules.sys.service.ShiroService;
import com.gaotao.modules.sys.service.SysMenuService;
import com.gaotao.modules.sys.service.SysObjectLanguageMenuService;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/menu"})
public class SysMenuController
extends AbstractController {
    @Autowired
    private SysMenuService sysMenuService;
    @Autowired
    private ShiroService shiroService;
    @Autowired
    private SysObjectLanguageMenuService sysObjectLanguageMenuService;

    @GetMapping(value={"/nav"})
    public R nav(@RequestParam(value="l") String l, @RequestParam(value="menuType") String menuType) {
        List<SysMenuEntity> menuList = this.sysMenuService.getUserMenuList(this.getUserId(), l, menuType);
        Set<String> permissions = this.shiroService.getUserPermissions(this.getUserId());
        return R.ok().put("menuList", (Object)menuList).put("permissions", (Object)permissions);
    }

    @GetMapping(value={"/list"})
    public List<SysMenuEntity> list() {
        List menuList = this.sysMenuService.list();
        for (SysMenuEntity sysMenuEntity : menuList) {
            SysMenuEntity parentMenuEntity = (SysMenuEntity)this.sysMenuService.getById((Serializable)((Object)sysMenuEntity.getParentId()));
            if (parentMenuEntity == null) continue;
            sysMenuEntity.setParentName(parentMenuEntity.getName());
        }
        return menuList;
    }

    @GetMapping(value={"/list/{language}"})
    public List<SysMenuEntity> listLanguage(@PathVariable String language) {
        List<SysMenuEntity> menuList = this.sysMenuService.listLanguage(language);
        for (SysMenuEntity sysMenuEntity : menuList) {
            System.out.println(sysMenuEntity.getParentId());
            SysMenuEntity parentMenuEntity = this.sysMenuService.getByIdLanguage(sysMenuEntity.getParentId(), language);
            if (parentMenuEntity == null) continue;
            sysMenuEntity.setParentName(parentMenuEntity.getName());
        }
        return menuList;
    }

    @GetMapping(value={"/select"})
    public R select() {
        List<SysMenuEntity> menuList = this.sysMenuService.queryNotButtonList();
        SysMenuEntity root = new SysMenuEntity();
        root.setMenuId("0");
        root.setName("\u4e00\u7ea7\u83dc\u5355");
        root.setParentId("-1");
        root.setOpen(true);
        menuList.add(root);
        return R.ok().put("menuList", (Object)menuList);
    }

    @GetMapping(value={"/info/{menuId}"})
    public R info(@PathVariable(value="menuId") String menuId) {
        SysMenuEntity menu = (SysMenuEntity)this.sysMenuService.getById((Serializable)((Object)menuId));
        return R.ok().put("menu", (Object)menu);
    }

    @SysLog(value="\u4fdd\u5b58\u83dc\u5355")
    @PostMapping(value={"/save"})
    public R save(@RequestBody SysMenuEntityDto menu) {
        this.verifyForm(menu);
        SysMenuEntity sysMenuEntity = new SysMenuEntity();
        SysObjectLanguageMenu sysObjectLanguageMenu = new SysObjectLanguageMenu();
        sysObjectLanguageMenu.setLanguageCode(menu.getLanguageCode());
        sysObjectLanguageMenu.setLanguageValue(menu.getName());
        BeanUtils.copyProperties((Object)menu, (Object)sysMenuEntity);
        this.sysMenuService.save(sysMenuEntity);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @SysLog(value="\u4fee\u6539\u83dc\u5355")
    @PostMapping(value={"/update"})
    public R update(@RequestBody SysMenuEntity menu) {
        this.verifyForm(menu);
        this.sysMenuService.updateById(menu);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @SysLog(value="\u5220\u9664\u83dc\u5355")
    @PostMapping(value={"/delete/{menuId}"})
    public R delete(@PathVariable(value="menuId") String menuId) {
        List<SysMenuEntity> menuList = this.sysMenuService.queryListParentId(menuId);
        if (menuList.size() > 0) {
            return R.error(this.getLanguageMsg("200209"));
        }
        this.sysMenuService.delete(menuId);
        return R.ok(this.getLanguageMsg("200000"));
    }

    private void verifyForm(SysMenuEntity menu) {
        if (StringUtils.isBlank((String)menu.getName())) {
            throw new XJException(this.getLanguageMsg("200210"));
        }
        if (menu.getParentId() == null) {
            throw new XJException(this.getLanguageMsg("200211"));
        }
        if (menu.getType().intValue() == Constant.MenuType.MENU.getValue() && StringUtils.isBlank((String)menu.getUrl())) {
            throw new XJException(this.getLanguageMsg("200212"));
        }
        int parentType = Constant.MenuType.CATALOG.getValue();
        if (!"0".equals(menu.getParentId())) {
            SysMenuEntity parentMenu = (SysMenuEntity)this.sysMenuService.getById((Serializable)((Object)menu.getParentId()));
            parentType = parentMenu.getType();
        }
        if (menu.getType().intValue() == Constant.MenuType.CATALOG.getValue() || menu.getType().intValue() == Constant.MenuType.MENU.getValue()) {
            if (parentType != Constant.MenuType.CATALOG.getValue()) {
                throw new XJException(this.getLanguageMsg("200213"));
            }
            return;
        }
        if (menu.getType().intValue() == Constant.MenuType.BUTTON.getValue()) {
            if (parentType != Constant.MenuType.MENU.getValue()) {
                throw new XJException(this.getLanguageMsg("200214"));
            }
            return;
        }
    }

    @PostMapping(value={"/searchMenuList"})
    public R searchMenuList(@RequestBody SysMenuEntity menu) {
        List<SysMenuEntity> menuList = this.sysMenuService.searchMenuList(menu);
        return R.ok().put("menuList", (Object)menuList);
    }

    @PostMapping(value={"searchMenuLanguageById"})
    public R searchMenuLanguageById(@RequestBody SysObjectLanguageMenu sysObjectLanguageMenu) {
        List<SysObjectLanguageMenu> list = this.sysMenuService.searchMenuLanguageById(sysObjectLanguageMenu);
        return R.ok().put("menuLanguageList", (Object)list);
    }

    @PostMapping(value={"saveMenuLanguage"})
    public R saveMenuLanguage(@RequestBody List<SysObjectLanguageMenu> sysObjectLanguageMenu) {
        if (this.sysMenuService.saveMenuLanguage(sysObjectLanguageMenu).booleanValue()) {
            return R.ok(this.getLanguageMsg("200000"));
        }
        return R.error(this.getLanguageMsg("200215"));
    }
}

