/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.report.controller;

import com.gaotao.common.utils.R;
import com.gaotao.modules.report.data.CustomerReportData;
import com.gaotao.modules.report.data.CustomerReportRoleData;
import com.gaotao.modules.report.data.CustomerSearchColumnData;
import com.gaotao.modules.report.data.SearchReportData;
import com.gaotao.modules.report.service.ReportService;
import com.gaotao.modules.sys.controller.AbstractController;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/report"})
public class ReportController
extends AbstractController {
    @Autowired
    private ReportService reportService;

    @RequestMapping(value={"getReportTypeList"})
    public R getReportTypeList(@RequestBody Map<String, String> inMap) {
        List<Map<String, Object>> resultList = this.reportService.getReportTypeList(inMap);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000")).put("rows", (Object)resultList).put("total", (Object)resultList.size());
    }

    @RequestMapping(value={"getCustomerReportList"})
    public R getCustomerReportList(@RequestBody SearchReportData inData) {
        List<CustomerReportData> resultList = this.reportService.getCustomerReportList(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000")).put("rows", (Object)resultList).put("total", (Object)resultList.size());
    }

    @RequestMapping(value={"addCustomerReport"})
    public R addCustomerReport(@RequestBody SearchReportData inData) {
        SearchReportData resultRow = this.reportService.addCustomerReport(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000")).put("row", (Object)resultRow);
    }

    @RequestMapping(value={"getCustomerReportByReportId"})
    public R getCustomerReportByReportId(@RequestBody SearchReportData inData) {
        CustomerReportData resultRow = this.reportService.getCustomerReportByReportId(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000")).put("row", (Object)resultRow);
    }

    @RequestMapping(value={"saveCustomerReport"})
    public R saveCustomerReport(@RequestBody SearchReportData inData) {
        this.reportService.saveCustomerReport(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000"));
    }

    @RequestMapping(value={"getSearchColumnsByReportId"})
    public R getSearchColumnsByReportId(@RequestBody SearchReportData inData) {
        List<CustomerSearchColumnData> resultList = this.reportService.getSearchColumnsByReportId(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000")).put("rows", (Object)resultList).put("total", (Object)resultList.size());
    }

    @RequestMapping(value={"autoProcessSearchColumn"})
    public R autoProcessSearchColumn(@RequestBody SearchReportData inData) {
        this.reportService.autoProcessSearchColumn(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000"));
    }

    @RequestMapping(value={"saveCustomerSearchColumns"})
    public R saveCustomerSearchColumns(@RequestBody Map<String, Object> inMap) {
        this.reportService.saveCustomerSearchColumns(inMap);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000"));
    }

    @RequestMapping(value={"runCustomerReport"})
    public R runCustomerReport(@RequestBody Map<String, Object> inMap) {
        Map<String, Object> resultMap = this.reportService.runCustomerReport(inMap);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000")).put("resultMap", (Object)resultMap);
    }

    @RequestMapping(value={"deleteCustomerReport"})
    public R deleteCustomerReport(@RequestBody SearchReportData inData) {
        this.reportService.deleteCustomerReport(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000"));
    }

    @RequestMapping(value={"deleteCustomerReportSearchColumn"})
    public R deleteCustomerReportSearchColumn(@RequestBody CustomerSearchColumnData inData) {
        this.reportService.deleteCustomerReportSearchColumn(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000"));
    }

    @RequestMapping(value={"getAuthRoles"})
    public R getAuthRoles(@RequestBody SearchReportData inData) {
        List<CustomerReportRoleData> resultList = this.reportService.getAuthRoles(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000")).put("rows", (Object)resultList).put("total", (Object)resultList.size());
    }

    @RequestMapping(value={"saveAuthSingleCustomerReport"})
    public R saveAuthSingleCustomerReport(@RequestBody Map<String, Object> inMap) {
        this.reportService.saveAuthSingleCustomerReport(inMap);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000"));
    }

    @RequestMapping(value={"getUserCustomerReportList"})
    public R getUserCustomerReportList(@RequestBody SearchReportData inData) {
        List<CustomerReportData> resultList = this.reportService.getUserCustomerReportList(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000")).put("rows", (Object)resultList).put("total", (Object)resultList.size());
    }

    @RequestMapping(value={"getCustomerReportAuths"})
    public R getCustomerReportAuths(@RequestBody SearchReportData inData) {
        List<CustomerReportData> resultList = this.reportService.getCustomerReportAuths(inData);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000")).put("rows", (Object)resultList).put("total", (Object)resultList.size());
    }

    @RequestMapping(value={"saveCustomerReportAuths"})
    public R saveCustomerReportAuths(@RequestBody Map<String, Object> inMap) {
        this.reportService.saveCustomerReportAuths(inMap);
        return R.ok().put("code", (Object)200).put("msg", (Object)this.getLanguageMsg("200000"));
    }

    @RequestMapping(value={"getCustomerReportData"})
    public R getCustomerReportData(@RequestBody SearchReportData inData) {
        Map<String, Object> resultMap = this.reportService.getCustomerReportData(inData);
        return R.ok().put("code", (Object)200).put("resultMap", (Object)resultMap).put("msg", (Object)this.getLanguageMsg("200000"));
    }
}

