/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.redis;

import com.gaotao.common.utils.RedisKeys;
import com.gaotao.common.utils.RedisUtils;
import com.gaotao.modules.sys.entity.SysConfigEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysConfigRedis {
    @Autowired
    private RedisUtils redisUtils;

    public void saveOrUpdate(SysConfigEntity config) {
        if (config == null) {
            return;
        }
        String key = RedisKeys.getSysConfigKey(config.getParamKey());
        this.redisUtils.set(key, config);
    }

    public void delete(String configKey) {
        String key = RedisKeys.getSysConfigKey(configKey);
        this.redisUtils.delete(key);
    }

    public SysConfigEntity get(String configKey) {
        String key = RedisKeys.getSysConfigKey(configKey);
        return this.redisUtils.get(key, SysConfigEntity.class);
    }
}

