/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.controller;

import com.gaotao.common.utils.R;
import com.gaotao.modules.sys.controller.AbstractController;
import com.gaotao.modules.sys.entity.SysUserEntity;
import com.gaotao.modules.sys.form.SysLoginForm;
import com.gaotao.modules.sys.service.SysCaptchaService;
import com.gaotao.modules.sys.service.SysUserService;
import com.gaotao.modules.sys.service.SysUserTokenService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysLoginController
extends AbstractController {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserTokenService sysUserTokenService;
    @Autowired
    private SysCaptchaService sysCaptchaService;

    @GetMapping(value={"captcha.jpg"})
    public void captcha(HttpServletResponse response, String uuid) throws IOException {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setContentType("image/jpeg");
        BufferedImage image = this.sysCaptchaService.getCaptcha(uuid);
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @PostMapping(value={"/sys/login"})
    public Map<String, Object> login(@RequestBody SysLoginForm form, HttpServletRequest request) throws IOException {
        HttpSession session = request.getSession();
        SysUserEntity user = this.sysUserService.queryByUserName(form.getUsername());
        if (user == null || !user.getPassword().equals(new Sha256Hash((Object)form.getPassword(), (Object)user.getSalt()).toHex())) {
            return R.error(this.getLanguageMsg("200207"));
        }
        if (user.getStatus() == 0) {
            return R.error(this.getLanguageMsg("200208"));
        }
        session.setAttribute("user", (Object)user);
        R r = this.sysUserTokenService.createToken(user.getUserId());
        r.put("language", (Object)user.getLanguageDefault());
        return r;
    }

    @PostMapping(value={"/sys/logout"})
    public R logout() {
        this.sysUserTokenService.logout(this.getUserId());
        return R.ok(this.getLanguageMsg("200000"));
    }
}

