/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.report.service.impl;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.JdbcConstants;
import com.alibaba.fastjson2.JSON;
import com.gaotao.common.exception.XJException;
import com.gaotao.common.utils.DateUtil;
import com.gaotao.modules.report.dao.ProcedureDao;
import com.gaotao.modules.report.dao.ReportDao;
import com.gaotao.modules.report.data.CustomerReportColumnData;
import com.gaotao.modules.report.data.CustomerReportData;
import com.gaotao.modules.report.data.CustomerReportRoleData;
import com.gaotao.modules.report.data.CustomerSearchColumnData;
import com.gaotao.modules.report.data.SearchReportData;
import com.gaotao.modules.report.service.ReportService;
import com.gaotao.modules.sys.service.SysMsgService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReportServiceImpl
implements ReportService {
    @Autowired
    private ReportDao reportDao;
    @Autowired
    private ProcedureDao procedureDao;
    @Autowired
    private SysMsgService sysMsgService;

    @Override
    public List<Map<String, Object>> getReportTypeList(Map<String, String> inMap) {
        String type = inMap.get("type");
        String secondType = "";
        if (inMap.containsKey("secondType")) {
            secondType = inMap.get("secondType");
        }
        return this.reportDao.getReportTypeList(type, secondType);
    }

    @Override
    public List<CustomerReportData> getCustomerReportList(SearchReportData inData) {
        String site = inData.getSite();
        String reportType = inData.getReportType();
        String reportName = inData.getReportName();
        return this.reportDao.getCustomerReportList(site, reportType, reportName);
    }

    @Override
    @Transactional
    public SearchReportData addCustomerReport(SearchReportData inData) {
        String site = inData.getSite();
        String currentDate = DateUtil.getStringDate(new Date(), "yyyyMMdd");
        String createdBy = inData.getUsername();
        String reportId = this.getCustomerReportId(site, "CR", currentDate);
        inData.setReportId(reportId);
        inData.setCreatedBy(createdBy);
        inData.setCreatedDate(new Date());
        this.reportDao.insertCustomerReport(inData);
        return inData;
    }

    public String getCustomerReportId(String site, String serialType, String currentDate) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(site);
        params.add(serialType);
        params.add(currentDate);
        List<Map<String, Object>> resultList = this.procedureDao.getProcedureData("getCustomerReportId", params);
        Map<String, Object> resultRow = resultList.get(0);
        return String.valueOf(resultRow.get("serial_no"));
    }

    @Override
    public CustomerReportData getCustomerReportByReportId(SearchReportData inData) {
        return this.reportDao.getCustomerReportByReportId(inData);
    }

    @Override
    public void saveCustomerReport(SearchReportData inData) {
        String username = inData.getUsername();
        inData.setUpdatedBy(username);
        inData.setUpdatedDate(new Date());
        this.reportDao.updateCustomerReport(inData);
    }

    @Override
    public List<CustomerSearchColumnData> getSearchColumnsByReportId(SearchReportData inData) {
        return this.reportDao.getSearchColumnsByReportId(inData);
    }

    @Override
    @Transactional
    public void autoProcessSearchColumn(SearchReportData inData) {
        String site = inData.getSite();
        String reportId = inData.getReportId();
        String username = inData.getUsername();
        ArrayList<CustomerSearchColumnData> newColumnList = new ArrayList<CustomerSearchColumnData>();
        List<CustomerSearchColumnData> columnList = this.reportDao.getSearchColumnsByReportId(inData);
        int sortNo = 0;
        if (columnList.size() == 0) {
            sortNo = 1;
        } else {
            sortNo = columnList.get(columnList.size() - 1).getSortNo();
            ++sortNo;
        }
        CustomerReportData customerReportData = this.reportDao.getCustomerReportByReportId(inData);
        String reportSql = customerReportData.getReportSql();
        if (reportSql == null || "".equals(reportSql.trim())) {
            throw new XJException(this.sysMsgService.getLanguageMsg("200151"));
        }
        reportSql = reportSql.trim();
        List<String> tempColumns = this.processReportSqlSearchCon(reportSql);
        HashMap<String, Integer> saveColumnMap = new HashMap<String, Integer>();
        for (CustomerSearchColumnData searchColumn : columnList) {
            saveColumnMap.put(searchColumn.getColumnField(), 1);
        }
        for (String str : tempColumns) {
            if (saveColumnMap.containsKey(str)) continue;
            CustomerSearchColumnData tempData = new CustomerSearchColumnData(reportId, str, "", "\u6587\u672c", "", sortNo, "");
            tempData.setSite(site);
            tempData.setCreatedBy(username);
            tempData.setCreatedDate(new Date());
            ++sortNo;
            newColumnList.add(tempData);
            saveColumnMap.put(str, 1);
        }
        if (newColumnList.size() > 0) {
            this.reportDao.batchInsertCustomerReportSearchColumns(newColumnList);
        }
    }

    public List<String> processReportSqlSearchCon(String reportSql) {
        ArrayList<String> resultList = new ArrayList<String>();
        int checkIndex = reportSql.indexOf("${");
        if (checkIndex <= 0) {
            return new ArrayList<String>();
        }
        int lastIndex = reportSql.lastIndexOf("}");
        String regex = "\\$\\{[^}]*\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(reportSql);
        while (matcher.find()) {
            String tempColumn = matcher.group(0);
            resultList.add(tempColumn.substring(2, tempColumn.length() - 1));
        }
        return resultList;
    }

    @Override
    @Transactional
    public void saveCustomerSearchColumns(Map<String, Object> inMap) {
        String strPageData = String.valueOf(inMap.get("pageData"));
        SearchReportData pageData = (SearchReportData)JSON.parseObject((String)strPageData, SearchReportData.class);
        String strSearchColumnList = String.valueOf(inMap.get("searchColumnList"));
        List searchColumnList = JSON.parseArray((String)strSearchColumnList, CustomerSearchColumnData.class);
        String username = pageData.getUsername();
        for (CustomerSearchColumnData searchColumnData : searchColumnList) {
            searchColumnData.setUpdatedBy(username);
            searchColumnData.setUpdatedDate(new Date());
        }
        this.reportDao.saveCustomerSearchColumns(searchColumnList);
    }

    @Override
    public Map<String, Object> runCustomerReport(Map<String, Object> inMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String strPageData = String.valueOf(inMap.get("pageData"));
        SearchReportData pageData = (SearchReportData)JSON.parseObject((String)strPageData, SearchReportData.class);
        String strSearchColumnList = String.valueOf(inMap.get("searchColumnList"));
        List searchColumnList = JSON.parseArray((String)strSearchColumnList, CustomerSearchColumnData.class);
        HashMap<String, CustomerSearchColumnData> paramMap = new HashMap<String, CustomerSearchColumnData>();
        for (CustomerSearchColumnData searchColumnData : searchColumnList) {
            paramMap.put(searchColumnData.getColumnField(), searchColumnData);
        }
        CustomerReportData customerReport = this.reportDao.getCustomerReportByReportId(pageData);
        String reportSql = customerReport.getReportSql();
        String columnSql = reportSql.replaceAll("\\\n", " ");
        StringBuilder queryColumnSql = new StringBuilder("");
        String regex = "\\$\\{[^}]*\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(columnSql);
        int startIndex = 0;
        boolean endIndex = false;
        while (matcher.find()) {
            String strKey = matcher.group(0);
            String columnKey = strKey.substring(2, strKey.length() - 1);
            if (startIndex == 0) {
                queryColumnSql.append(columnSql.substring(0, matcher.start()));
            } else {
                queryColumnSql.append(columnSql.substring(startIndex, matcher.start()));
            }
            startIndex = matcher.end();
            if (paramMap.containsKey(columnKey)) {
                CustomerSearchColumnData tempData = (CustomerSearchColumnData)paramMap.get(columnKey);
                String columnType = tempData.getColumnType();
                String columnValue = tempData.getColumnDefaultValue();
                if ("\u6587\u672c".equals(columnType)) {
                    queryColumnSql.append("'" + columnValue + "'");
                    continue;
                }
                queryColumnSql.append(columnValue);
                continue;
            }
            queryColumnSql.append("''");
        }
        if (startIndex < columnSql.length()) {
            queryColumnSql.append(columnSql.substring(startIndex, columnSql.length()));
        }
        if (startIndex == 0) {
            queryColumnSql = new StringBuilder(columnSql);
        }
        List<String> columnList = this.parseSqlColumns(queryColumnSql.toString(), JdbcConstants.SQL_SERVER.toString());
        ArrayList<CustomerReportColumnData> columnRows = new ArrayList<CustomerReportColumnData>();
        for (String str : columnList) {
            CustomerReportColumnData rempColumn = new CustomerReportColumnData(str, "center", "center", str, "ori", 0);
            columnRows.add(rempColumn);
        }
        resultMap.put("columnRows", columnRows);
        resultMap.put("customerReport", customerReport);
        List<Map<String, Object>> resultRows = this.reportDao.runCustomerReportSql(queryColumnSql.toString());
        resultMap.put("resultRows", resultRows);
        return resultMap;
    }

    public List<String> processReportSqlSearchConKey(String reportSql) {
        ArrayList<String> resultList = new ArrayList<String>();
        int checkIndex = reportSql.indexOf("${");
        if (checkIndex <= 0) {
            throw new XJException(this.sysMsgService.getLanguageMsg("200152"));
        }
        int lastIndex = reportSql.lastIndexOf("}");
        String regex = "\\$\\{[^}]*\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(reportSql);
        while (matcher.find()) {
            String tempColumn = matcher.group(0);
            resultList.add(tempColumn);
        }
        return resultList;
    }

    public List<String> parseSqlColumns(String sql, String dbType) {
        String sqlResults = SQLUtils.format((String)sql, (String)dbType);
        List stmtList = new ArrayList();
        stmtList = SQLUtils.parseStatements((String)sql, (String)dbType);
        ArrayList<String> columnList = new ArrayList<String>();
        for (SQLStatement sqlStatement : stmtList) {
            SQLServerSchemaStatVisitor visitor = new SQLServerSchemaStatVisitor();
            sqlStatement.accept((SQLASTVisitor)visitor);
            List list = ((SQLServerSelectQueryBlock)((SQLSelectStatement)sqlStatement).getSelect().getQuery()).getSelectList();
            for (SQLSelectItem item : list) {
                String columnAlias = item.getAlias();
                if (columnAlias == null || "".equals(columnAlias)) {
                    String colmunFiled = item.getExpr().toString();
                    int charIndex = colmunFiled.indexOf(".") + 1;
                    columnAlias = colmunFiled.substring(charIndex);
                } else {
                    columnAlias = columnAlias.substring(0, columnAlias.length());
                }
                columnList.add(columnAlias);
            }
            Map tables = visitor.getTables();
            List conditions = visitor.getConditions();
            Set relationships = visitor.getRelationships();
            for (TableStat.Condition condition : conditions) {
                String string = condition.getColumn().toString();
            }
        }
        return columnList;
    }

    @Override
    @Transactional
    public void deleteCustomerReport(SearchReportData inData) {
        String reportId = inData.getReportId();
        int countNums = this.reportDao.countUsedCustomerReportByReportId(reportId);
        if (countNums > 0) {
            throw new XJException(this.sysMsgService.getLanguageMsg("200153"));
        }
        this.reportDao.deleteCustomerReportSearchColumn(reportId, null);
        this.reportDao.deleteCustomerReportColumnByReportId(reportId);
        this.reportDao.deleteCustomerReportByReportId(reportId);
    }

    @Override
    public void deleteCustomerReportSearchColumn(CustomerSearchColumnData inData) {
        String reportId = inData.getReportId();
        String columnField = inData.getColumnField();
        this.reportDao.deleteCustomerReportSearchColumn(reportId, columnField);
    }

    @Override
    public List<CustomerReportRoleData> getAuthRoles(SearchReportData inData) {
        String reportId = inData.getReportId();
        return this.reportDao.getAuthRoles(reportId);
    }

    @Override
    @Transactional
    public void saveAuthSingleCustomerReport(Map<String, Object> inMap) {
        String strPageData = String.valueOf(inMap.get("pageData"));
        SearchReportData pageData = (SearchReportData)JSON.parseObject((String)strPageData, SearchReportData.class);
        String strAuthRoles = String.valueOf(inMap.get("authRoles"));
        List currentColumnList = JSON.parseArray((String)strAuthRoles, CustomerReportRoleData.class);
        String site = pageData.getSite();
        String reportId = pageData.getReportId();
        String username = pageData.getUsername();
        ArrayList<CustomerReportRoleData> saveAuthRoles = new ArrayList<CustomerReportRoleData>();
        for (CustomerReportRoleData reportRoleData : currentColumnList) {
            String checkedFlag = reportRoleData.getCheckedFlag();
            if (!"Y".equalsIgnoreCase(checkedFlag)) continue;
            reportRoleData.setSite(site);
            reportRoleData.setReportId(reportId);
            reportRoleData.setCreatedBy(username);
            reportRoleData.setCreatedDate(new Date());
            saveAuthRoles.add(reportRoleData);
        }
        this.reportDao.deleteCustomerReportRoleByReportId(reportId);
        if (saveAuthRoles.size() > 0) {
            this.reportDao.batchInsertCustomerReportRoles(saveAuthRoles);
        }
    }

    @Override
    public List<CustomerReportData> getUserCustomerReportList(SearchReportData inData) {
        String site = inData.getSite();
        String username = inData.getUsername();
        String reportType = inData.getReportType();
        String reportName = inData.getReportName().trim();
        return this.reportDao.getUserCustomerReportList(site, username, reportType, reportName);
    }

    @Override
    public List<CustomerReportData> getCustomerReportAuths(SearchReportData inData) {
        String site = inData.getSite();
        String roleId = inData.getRoleId();
        return this.reportDao.getCustomerReportAuths(site, roleId);
    }

    @Override
    @Transactional
    public void saveCustomerReportAuths(Map<String, Object> inMap) {
        String strPageData = String.valueOf(inMap.get("pageData"));
        SearchReportData pageData = (SearchReportData)JSON.parseObject((String)strPageData, SearchReportData.class);
        String strCustomerReports = String.valueOf(inMap.get("customerReports"));
        List currentCustomerReports = JSON.parseArray((String)strCustomerReports, CustomerReportData.class);
        String site = pageData.getSite();
        String roleId = pageData.getRoleId();
        String username = pageData.getUsername();
        ArrayList<CustomerReportRoleData> saveAuthRoles = new ArrayList<CustomerReportRoleData>();
        for (CustomerReportData CustomerReportData2 : currentCustomerReports) {
            CustomerReportRoleData customerReportRoleData = new CustomerReportRoleData();
            customerReportRoleData.setSite(site);
            customerReportRoleData.setReportId(CustomerReportData2.getReportId());
            customerReportRoleData.setRoleId(roleId);
            customerReportRoleData.setCreatedBy(username);
            customerReportRoleData.setCreatedDate(new Date());
            saveAuthRoles.add(customerReportRoleData);
        }
        this.reportDao.deleteCustomerReportRoleByRoleId(roleId);
        if (saveAuthRoles.size() > 0) {
            this.reportDao.batchInsertCustomerReportRoles(saveAuthRoles);
        }
    }

    @Override
    public Map<String, Object> getCustomerReportData(SearchReportData inData) {
        String site = inData.getSite();
        String reportId = inData.getReportId();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        CustomerReportData customerReport = this.reportDao.getCustomerReportByReportId(inData);
        String reportSql = customerReport.getReportSql();
        String columnSql = reportSql.replaceAll("\\\n", " ");
        StringBuilder queryColumnSql = new StringBuilder("");
        String regex = "\\$\\{[^}]*\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(columnSql);
        int startIndex = 0;
        boolean endIndex = false;
        while (matcher.find()) {
            String strKey = matcher.group(0);
            String columnKey = strKey.substring(2, strKey.length() - 1);
            if (startIndex == 0) {
                queryColumnSql.append(columnSql.substring(0, matcher.start()));
            } else {
                queryColumnSql.append(columnSql.substring(startIndex, matcher.start()));
            }
            startIndex = matcher.end();
            queryColumnSql.append("'*'");
        }
        if (startIndex < columnSql.length()) {
            queryColumnSql.append(columnSql.substring(startIndex, columnSql.length()));
        }
        if (startIndex == 0) {
            queryColumnSql = new StringBuilder(columnSql);
        }
        List<String> columnList = this.parseSqlColumns(queryColumnSql.toString(), JdbcConstants.SQL_SERVER.toString());
        ArrayList<CustomerReportColumnData> columnRows = new ArrayList<CustomerReportColumnData>();
        for (String str : columnList) {
            CustomerReportColumnData rempColumn = new CustomerReportColumnData(str, "center", "center", str, "ori", 0);
            columnRows.add(rempColumn);
        }
        resultMap.put("columnRows", columnRows);
        resultMap.put("customerReport", customerReport);
        return resultMap;
    }
}

