/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.report.service.impl;

import com.alibaba.fastjson2.JSON;
import com.gaotao.datasource.annotation.DataSource;
import com.gaotao.modules.report.dao.CmchReportDao;
import com.gaotao.modules.report.dao.ProcedureDao;
import com.gaotao.modules.report.data.TidBindInfoData;
import com.gaotao.modules.report.data.WaferTableHist;
import com.gaotao.modules.report.model.PartitionTableRules;
import com.gaotao.modules.report.service.CmchReportService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CmchReportServiceImpl
implements CmchReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CmchReportDao cmchReportDao;
    @Autowired
    private ProcedureDao procedureDao;

    @Override
    @DataSource(value="slave2")
    public List<WaferTableHist> getWaferTableHist(WaferTableHist inData) {
        String site = inData.getSite();
        String waferId = inData.getWaferId();
        String searchFlag = inData.getSearchFlag();
        if ("N".equalsIgnoreCase(searchFlag)) {
            return new ArrayList<WaferTableHist>();
        }
        if (null == waferId || "".equals(waferId)) {
            throw new RuntimeException("tid cannot be empty!");
        }
        this.refreshWaferIdBindNums(waferId);
        return this.cmchReportDao.getWaferTableHist(site, waferId);
    }

    public void refreshWaferIdBindNums(String waferId) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(waferId);
        this.procedureDao.execProduceData("refreshWaferIdBindNums", params);
    }

    @Override
    @DataSource(value="slave2")
    public Map<String, String> getTidBindInfo(TidBindInfoData inData) {
        String tid = inData.getTid();
        String searchFlag = inData.getSearchFlag();
        if ("N".equalsIgnoreCase(searchFlag)) {
            return new HashMap<String, String>();
        }
        if (null == tid || "".equals(tid)) {
            throw new RuntimeException("tid cannot be empty!");
        }
        if (tid.length() != 24) {
            throw new RuntimeException("TID length is not 24 characters!");
        }
        String chipModel = tid.substring(0, 8);
        PartitionTableRules tidRule = this.cmchReportDao.getPartitionTableRules(chipModel);
        int partFirstStart = tidRule.getPartFirstStart();
        int partFirstLens = tidRule.getPartFirstLens();
        int partSecondStart = tidRule.getPartSecondStart();
        int partSecondLens = tidRule.getPartSecondLens();
        StringBuffer sb = new StringBuffer();
        sb.append(tid.substring(0, 8) + "_");
        sb.append(tid.substring(partFirstStart, partFirstStart + partFirstLens) + "_");
        if (partSecondLens > 0) {
            sb.append(tid.substring(partSecondStart, partSecondStart + partSecondLens) + "_");
        }
        sb.append("wafer");
        String tableName = sb.toString();
        String businessTableName = tableName.replace("wafer", "business");
        this.logger.info("\u5b58\u50a8\u8fc7\u7a0b\u53c2\u6570TID:" + tid + ",wafer\u8868:" + tableName + ",\u4e1a\u52a1\u8868:" + businessTableName);
        Map<String, Object> resultMap = this.getTidBindBusinessData(tid, tableName, businessTableName);
        this.logger.info("\u5b58\u50a8\u8fc7\u7a0b\u8fd4\u56de\u6570\u636e:" + JSON.toJSONString(resultMap));
        HashMap<String, String> resultRow = new HashMap<String, String>();
        resultRow.put("rollNo", String.valueOf(resultMap.get("rollNo")));
        resultRow.put("waferId", String.valueOf(resultMap.get("waferId")));
        resultRow.put("resourceId", String.valueOf(resultMap.get("resourceId")));
        resultRow.put("bindTime", String.valueOf(resultMap.get("bindTime")));
        this.logger.info("\u8fd4\u56de\u6570\u636e:" + JSON.toJSONString(resultRow));
        return resultRow;
    }

    public Map<String, Object> getTidBindBusinessData(String tid, String tableName, String businessTableName) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(tid);
        params.add(tableName);
        params.add(businessTableName);
        List<Map<String, Object>> resultList = this.procedureDao.getProcedureData("getTidBindBusinessData", params);
        return resultList.get(0);
    }

    int checkTableIsExist(String tableName) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(tableName);
        List<Map<String, Object>> resultList = this.procedureDao.getProcedureData("checkTableIsExist", params);
        Map<String, Object> resultMap = resultList.get(0);
        return Integer.parseInt(String.valueOf(resultMap.get("resultNum")));
    }

    @Override
    @DataSource(value="slave2")
    public Map<String, String> getTidWaferAndBindInfoWithAls(TidBindInfoData inData) {
        String tid = inData.getTid();
        String searchFlag = inData.getSearchFlag();
        if ("N".equalsIgnoreCase(searchFlag)) {
            return new HashMap<String, String>();
        }
        if (null == tid || "".equals(tid)) {
            throw new RuntimeException("tid cannot be empty!");
        }
        int charLength = tid.trim().length();
        String chipModel = "";
        if (charLength == 24) {
            chipModel = tid.substring(0, 8);
        } else if (charLength == 14) {
            chipModel = tid.substring(0, 3);
        } else {
            throw new RuntimeException("The TID length does not meet the standard specifications!");
        }
        PartitionTableRules tidRule = this.cmchReportDao.getPartitionTableRules(chipModel, charLength);
        int partFirstStart = tidRule.getPartFirstStart();
        int partFirstLens = tidRule.getPartFirstLens();
        int partSecondStart = tidRule.getPartSecondStart();
        int partSecondLens = tidRule.getPartSecondLens();
        StringBuffer sb = new StringBuffer();
        if (charLength == 24) {
            sb.append(chipModel + "_");
            sb.append(tid.substring(partFirstStart, partFirstStart + partFirstLens) + "_");
        } else if (charLength == 14) {
            sb.append(chipModel);
            sb.append(tid.substring(partFirstStart, partFirstStart + partFirstLens) + "_");
        }
        if (partSecondLens > 0) {
            sb.append(tid.substring(partSecondStart, partSecondStart + partSecondLens) + "_");
        }
        sb.append("wafer");
        String tableName = sb.toString();
        String businessTableName = tableName.replace("wafer", "business");
        String relationTableName = tableName.replace("wafer", "relation");
        Map<String, Object> resultMap = this.getTidWaferAndBindInfoWithAlsInfo(tid, tableName, businessTableName, relationTableName);
        HashMap<String, String> resultRow = new HashMap<String, String>();
        resultRow.put("rollNo", String.valueOf(resultMap.get("rollNo")));
        resultRow.put("waferId", String.valueOf(resultMap.get("waferId")));
        resultRow.put("resourceId", String.valueOf(resultMap.get("resourceId")));
        resultRow.put("epc", String.valueOf(resultMap.get("epc")));
        resultRow.put("bindTime", String.valueOf(resultMap.get("bindTime")));
        resultRow.put("orgId", String.valueOf(resultMap.get("orgId")));
        resultRow.put("retailerName", String.valueOf(resultMap.get("retailerName")));
        resultRow.put("ordSeq", String.valueOf(resultMap.get("ordSeq")));
        resultRow.put("salesOrderNumber", String.valueOf(resultMap.get("salesOrderNumber")));
        resultRow.put("ticketCenterId", String.valueOf(resultMap.get("ticketCenterId")));
        resultRow.put("deviceBrand", String.valueOf(resultMap.get("deviceBrand")));
        resultRow.put("deviceType", String.valueOf(resultMap.get("deviceType")));
        resultRow.put("controllerHostName", String.valueOf(resultMap.get("controllerHostName")));
        resultRow.put("productionDate", String.valueOf(resultMap.get("productionDate")));
        resultRow.put("deviceControllerSoftwareVersion", String.valueOf(resultMap.get("deviceControllerSoftwareVersion")));
        return resultRow;
    }

    public Map<String, Object> getTidWaferAndBindInfoWithAlsInfo(String tid, String tableName, String businessTableName, String relationTableName) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(tid);
        params.add(tableName);
        params.add(businessTableName);
        params.add(relationTableName);
        List<Map<String, Object>> resultList = this.procedureDao.getProcedureData("getTidWaferAndBindInfoWithAlsInfo", params);
        Map<String, Object> resultMap = resultList.get(0);
        return resultMap;
    }
}

