/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.report.dao.impl;

import com.gaotao.modules.report.dao.AlsReportDao;
import com.gaotao.modules.report.data.AlsCsvFileHeader;
import com.gaotao.modules.report.data.AlsCsvTidReportInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class AlsReportDaoImpl
implements AlsReportDao {
    @Autowired
    private NamedParameterJdbcTemplate parameterJdbcTemplate;

    @Override
    public List<AlsCsvFileHeader> getAlsCsvFileHeaderByCon(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT id, production_date, sales_order_number, ord_seq, bat_seq, gtin, org_id, table_name,");
        sql.append(" epc_lock, kill_pwd_lock, access_pwd_lock, user_mem_lock, tid_lock, print_job_id, ticket_center_id, device_brand,");
        sql.append(" device_type, device_internal_name, device_serial_number, device_controller_software_version, controller_host_name, controller_user_name");
        sql.append(" FROM als_csv_header_hist");
        sql.append(" WHERE 1 = 1");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND retailer_name LIKE '%" + retailerName + "%'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != startProductionDate) {
            sql.append(" AND production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(AlsCsvFileHeader.class));
    }

    @Override
    public List<AlsCsvTidReportInfo> getAlsTidInfoReport(int headerId, String tableName, String tid, String epc, int pageIndex, int pageSize) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT ach.production_date, ach.sales_order_number, ach.ord_seq, ach.bat_seq, ach.gtin,");
        sql.append(" ach.org_id, ach.epc_lock, ach.kill_pwd_lock, ach.access_pwd_lock, ach.user_mem_lock,");
        sql.append(" ach.tid_lock, ach.print_job_id, ach.ticket_center_id, ach.device_brand, ach.device_type,");
        sql.append(" ach.device_internal_name, ach.device_serial_number, ach.device_controller_software_version, ach.controller_host_name, ach.controller_user_name,");
        sql.append(" ati.access_pwd, ati.tid, ati.epc, ati.kill_pwd, ati.user_data,");
        sql.append(" retailer_name,");
        sql.append(" ati.wafer_id, tbr.roll_no, tbr.resource_id, tbr.binded_time");
        sql.append(" FROM als_csv_header_hist ach");
        sql.append(" LEFT JOIN " + tableName + " ati ON ati.als_header_id = ach.id");
        sql.append(" LEFT JOIN tid_bind_roll tbr ON tbr.id = ati.roll_id");
        sql.append(" WHERE ach.id = :headerId AND ati.als_header_id = ach.id");
        if (null != tid && !"".equals(tid)) {
            sql.append(" AND ati.tid = :tid");
            paramMap.put("tid", tid);
        }
        if (null != epc && !"".equals(epc)) {
            sql.append(" AND ati.epc = :epc");
            paramMap.put("epc", epc);
        }
        paramMap.put("headerId", headerId);
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(AlsCsvTidReportInfo.class));
    }

    @Override
    public Integer countAlsTidReport(int headerId, String tableName, String tid, String epc) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT COUNT(1)");
        sql.append(" FROM als_csv_header_hist ach");
        sql.append(" LEFT JOIN " + tableName + " ati ON ati.als_header_id = ach.id");
        sql.append(" LEFT JOIN tid_bind_roll tbr ON tbr.id = ati.roll_id");
        sql.append(" WHERE ach.id = :headerId AND ati.als_header_id = ach.id");
        if (null != tid && !"".equals(tid)) {
            sql.append(" AND ati.tid = :tid");
            paramMap.put("tid", tid);
        }
        if (null != epc && !"".equals(epc)) {
            sql.append(" AND ati.epc = :epc");
            paramMap.put("epc", epc);
        }
        paramMap.put("headerId", headerId);
        return (Integer)this.parameterJdbcTemplate.queryForObject(sql.toString(), paramMap, Integer.class);
    }

    @Override
    public AlsCsvFileHeader getOneAlsCsvFileHeaderByCon(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT TOP 1 id, production_date, sales_order_number, ord_seq, bat_seq, gtin, org_id, table_name,");
        sql.append(" epc_lock, kill_pwd_lock, access_pwd_lock, user_mem_lock, tid_lock, print_job_id, ticket_center_id, device_brand,");
        sql.append(" device_type, device_internal_name, device_serial_number, device_controller_software_version, controller_host_name, controller_user_name");
        sql.append(" FROM als_csv_header_hist");
        sql.append(" WHERE 1 = 1");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND retailer_name LIKE '%" + retailerName + "%'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != startProductionDate) {
            sql.append(" AND production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        sql.append(" ORDER BY id");
        List resultList = this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(AlsCsvFileHeader.class));
        if (resultList.size() != 0 && !resultList.isEmpty()) {
            return (AlsCsvFileHeader)resultList.get(0);
        }
        return null;
    }

    @Override
    public List<AlsCsvTidReportInfo> getAlsTidInfoReportWithPage(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate, String tableName, String tid, String epc, int pageIndex, int pageSize) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT ach.production_date, ach.sales_order_number, ach.ord_seq, ach.bat_seq, ach.gtin,");
        sql.append(" ach.org_id, ach.epc_lock, ach.kill_pwd_lock, ach.access_pwd_lock, ach.user_mem_lock,");
        sql.append(" ach.tid_lock, ach.print_job_id, ach.ticket_center_id, ach.device_brand, ach.device_type,");
        sql.append(" ach.device_internal_name, ach.device_serial_number, ach.device_controller_software_version, ach.controller_host_name, ach.controller_user_name,");
        sql.append(" ati.access_pwd, ati.tid, ati.epc, ati.kill_pwd, ati.user_data,");
        sql.append(" retailer_name,");
        sql.append(" ati.wafer_id, tbr.roll_no, tbr.resource_id, tbr.binded_time AS bindTime");
        sql.append(" FROM als_csv_header_hist ach");
        sql.append(" LEFT JOIN " + tableName + " ati ON ati.als_header_id = ach.id");
        sql.append(" LEFT JOIN tid_bind_roll tbr ON tbr.id = ati.roll_id");
        sql.append(" WHERE ati.als_header_id = ach.id");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND ach.org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND ach.retailer_name LIKE '" + retailerName + "'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ach.ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND ach.sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND ach.gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != startProductionDate) {
            sql.append(" AND ach.production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND ach.production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        if (null != tid && !"".equals(tid)) {
            sql.append(" AND ati.tid = :tid");
            paramMap.put("tid", tid);
        }
        if (null != epc && !"".equals(epc)) {
            sql.append(" AND ati.epc = :epc");
            paramMap.put("epc", epc);
        }
        sql.append(" ORDER BY ach.id ASC");
        sql.append(" OFFSET " + (pageIndex - 1) * pageSize + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY");
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(AlsCsvTidReportInfo.class));
    }

    @Override
    public List<AlsCsvTidReportInfo> getAlsTidInfoReportWithExport(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate, String tableName, String tid, String epc) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT ach.production_date, ach.sales_order_number, ach.ord_seq, ach.bat_seq, ach.gtin,");
        sql.append(" ach.org_id, ach.epc_lock, ach.kill_pwd_lock, ach.access_pwd_lock, ach.user_mem_lock,");
        sql.append(" ach.tid_lock, ach.print_job_id, ach.ticket_center_id, ach.device_brand, ach.device_type,");
        sql.append(" ach.device_internal_name, ach.device_serial_number, ach.device_controller_software_version, ach.controller_host_name, ach.controller_user_name,");
        sql.append(" ati.access_pwd, ati.tid, ati.epc, ati.kill_pwd, ati.user_data,");
        sql.append(" retailer_name,");
        sql.append(" ati.wafer_id, tbr.roll_no, tbr.resource_id, tbr.binded_time");
        sql.append(" FROM als_csv_header_hist ach");
        sql.append(" LEFT JOIN " + tableName + " ati ON ati.als_header_id = ach.id");
        sql.append(" LEFT JOIN tid_bind_roll tbr ON tbr.id = ati.roll_id");
        sql.append(" WHERE ati.als_header_id = ach.id");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND ach.org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND ach.retailer_name LIKE '" + retailerName + "'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ach.ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND ach.sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND ach.gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != startProductionDate) {
            sql.append(" AND ach.production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND ach.production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        if (null != tid && !"".equals(tid)) {
            sql.append(" AND ati.tid = :tid");
            paramMap.put("tid", tid);
        }
        if (null != epc && !"".equals(epc)) {
            sql.append(" AND ati.epc = :epc");
            paramMap.put("epc", epc);
        }
        sql.append(" ORDER BY ach.id ASC");
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(AlsCsvTidReportInfo.class));
    }

    @Override
    public Integer countAlsTidReportWithPage(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate, String tableName, String tid, String epc) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT COUNT(1)");
        sql.append(" FROM als_csv_header_hist ach");
        sql.append(" LEFT JOIN " + tableName + " ati ON ati.als_header_id = ach.id");
        sql.append(" LEFT JOIN tid_bind_roll tbr ON tbr.id = ati.roll_id");
        sql.append(" WHERE ati.als_header_id = ach.id");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND ach.org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND ach.retailer_name LIKE '" + retailerName + "'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ach.ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND ach.sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND ach.gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != startProductionDate) {
            sql.append(" AND ach.production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND ach.production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        if (null != tid && !"".equals(tid)) {
            sql.append(" AND ati.tid = :tid");
            paramMap.put("tid", tid);
        }
        if (null != epc && !"".equals(epc)) {
            sql.append(" AND ati.epc = :epc");
            paramMap.put("epc", epc);
        }
        return (Integer)this.parameterJdbcTemplate.queryForObject(sql.toString(), paramMap, Integer.class);
    }

    @Override
    public AlsCsvFileHeader getOneAlsCsvFileHeaderByCon(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate, String ticketCenterId, String deviceBrand, String deviceType, String controllerHostName, String controllerUserName) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT TOP 1 id, production_date, sales_order_number, ord_seq, bat_seq, gtin, org_id, table_name,");
        sql.append(" epc_lock, kill_pwd_lock, access_pwd_lock, user_mem_lock, tid_lock, print_job_id, ticket_center_id, device_brand,");
        sql.append(" device_type, device_internal_name, device_serial_number, device_controller_software_version, controller_host_name, controller_user_name");
        sql.append(" FROM als_csv_header_hist");
        sql.append(" WHERE 1 = 1");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND retailer_name LIKE '%" + retailerName + "%'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != startProductionDate) {
            sql.append(" AND production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        if (null != ticketCenterId && !"".equals(ticketCenterId)) {
            sql.append(" AND ticket_center_id = :ticketCenterId");
            paramMap.put("ticketCenterId", ticketCenterId);
        }
        if (null != deviceBrand && !"".equals(deviceBrand)) {
            sql.append(" AND device_brand = :deviceBrand");
            paramMap.put("deviceBrand", deviceBrand);
        }
        if (null != deviceType && !"".equals(deviceType)) {
            sql.append(" AND device_type = :deviceType");
            paramMap.put("deviceType", deviceType);
        }
        if (null != controllerHostName && !"".equals(controllerHostName)) {
            sql.append(" AND controller_host_name = :controllerHostName");
            paramMap.put("controllerHostName", controllerHostName);
        }
        if (null != controllerUserName && !"".equals(controllerUserName)) {
            sql.append(" AND controller_user_name = :controllerUserName");
            paramMap.put("controllerUserName", controllerUserName);
        }
        sql.append(" ORDER BY id");
        List resultList = this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(AlsCsvFileHeader.class));
        if (resultList.size() != 0 && !resultList.isEmpty()) {
            return (AlsCsvFileHeader)resultList.get(0);
        }
        return null;
    }

    @Override
    public List<AlsCsvTidReportInfo> getAlsTidInfoReportWithExport(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate, String tableName, String tid, String epc, String ticketCenterId, String deviceBrand, String deviceType, String controllerHostName, String controllerUserName) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT ach.production_date, ach.sales_order_number, ach.ord_seq, ach.bat_seq, ach.gtin,");
        sql.append(" ach.org_id, ach.epc_lock, ach.kill_pwd_lock, ach.access_pwd_lock, ach.user_mem_lock,");
        sql.append(" ach.tid_lock, ach.print_job_id, ach.ticket_center_id, ach.device_brand, ach.device_type,");
        sql.append(" ach.device_internal_name, ach.device_serial_number, ach.device_controller_software_version, ach.controller_host_name, ach.controller_user_name,");
        sql.append(" ati.access_pwd, ati.tid, ati.epc, ati.kill_pwd, ati.user_data,");
        sql.append(" retailer_name,");
        sql.append(" ati.wafer_id, tbr.roll_no, tbr.resource_id, tbr.binded_time");
        sql.append(" FROM als_csv_header_hist ach");
        sql.append(" LEFT JOIN " + tableName + " ati ON ati.als_header_id = ach.id");
        sql.append(" LEFT JOIN tid_bind_roll tbr ON tbr.id = ati.roll_id");
        sql.append(" WHERE ati.als_header_id = ach.id");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND ach.org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND ach.retailer_name LIKE '" + retailerName + "'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ach.ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND ach.sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND ach.gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != startProductionDate) {
            sql.append(" AND ach.production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND ach.production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        if (null != ticketCenterId && !"".equals(ticketCenterId)) {
            sql.append(" AND ach.ticket_center_id = :ticketCenterId");
            paramMap.put("ticketCenterId", ticketCenterId);
        }
        if (null != deviceBrand && !"".equals(deviceBrand)) {
            sql.append(" AND ach.device_brand = :deviceBrand");
            paramMap.put("deviceBrand", deviceBrand);
        }
        if (null != deviceType && !"".equals(deviceType)) {
            sql.append(" AND ach.device_type = :deviceType");
            paramMap.put("deviceType", deviceType);
        }
        if (null != controllerHostName && !"".equals(controllerHostName)) {
            sql.append(" AND ach.controller_host_name = :controllerHostName");
            paramMap.put("controllerHostName", controllerHostName);
        }
        if (null != controllerUserName && !"".equals(controllerUserName)) {
            sql.append(" AND ach.controller_user_name = :controllerUserName");
            paramMap.put("controllerUserName", controllerUserName);
        }
        if (null != tid && !"".equals(tid)) {
            sql.append(" AND ati.tid = :tid");
            paramMap.put("tid", tid);
        }
        if (null != epc && !"".equals(epc)) {
            sql.append(" AND ati.epc = :epc");
            paramMap.put("epc", epc);
        }
        sql.append(" ORDER BY ach.id ASC");
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(AlsCsvTidReportInfo.class));
    }

    @Override
    public List<AlsCsvTidReportInfo> getAlsTidInfoReportWithPage(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate, String tableName, String tid, String epc, int pageIndex, int pageSize, String ticketCenterId, String deviceBrand, String deviceType, String controllerHostName, String controllerUserName) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT ach.production_date, ach.sales_order_number, ach.ord_seq, ach.bat_seq, ach.gtin,");
        sql.append(" ach.org_id, ach.epc_lock, ach.kill_pwd_lock, ach.access_pwd_lock, ach.user_mem_lock,");
        sql.append(" ach.tid_lock, ach.print_job_id, ach.ticket_center_id, ach.device_brand, ach.device_type,");
        sql.append(" ach.device_internal_name, ach.device_serial_number, ach.device_controller_software_version, ach.controller_host_name, ach.controller_user_name,");
        sql.append(" ati.access_pwd, ati.tid, ati.epc, ati.kill_pwd, ati.user_data,");
        sql.append(" retailer_name,");
        sql.append(" ati.wafer_id, tbr.roll_no, tbr.resource_id, tbr.binded_time AS bindTime");
        sql.append(" FROM als_csv_header_hist ach");
        sql.append(" LEFT JOIN " + tableName + " ati ON ati.als_header_id = ach.id");
        sql.append(" LEFT JOIN tid_bind_roll tbr ON tbr.id = ati.roll_id");
        sql.append(" WHERE ati.als_header_id = ach.id");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND ach.org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND ach.retailer_name LIKE '" + retailerName + "'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ach.ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND ach.sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND ach.gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != startProductionDate) {
            sql.append(" AND ach.production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND ach.production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        if (null != ticketCenterId && !"".equals(ticketCenterId)) {
            sql.append(" AND ach.ticket_center_id = :ticketCenterId");
            paramMap.put("ticketCenterId", ticketCenterId);
        }
        if (null != deviceBrand && !"".equals(deviceBrand)) {
            sql.append(" AND ach.device_brand = :deviceBrand");
            paramMap.put("deviceBrand", deviceBrand);
        }
        if (null != deviceType && !"".equals(deviceType)) {
            sql.append(" AND ach.device_type = :deviceType");
            paramMap.put("deviceType", deviceType);
        }
        if (null != controllerHostName && !"".equals(controllerHostName)) {
            sql.append(" AND ach.controller_host_name = :controllerHostName");
            paramMap.put("controllerHostName", controllerHostName);
        }
        if (null != controllerUserName && !"".equals(controllerUserName)) {
            sql.append(" AND ach.controller_user_name = :controllerUserName");
            paramMap.put("controllerUserName", controllerUserName);
        }
        if (null != tid && !"".equals(tid)) {
            sql.append(" AND ati.tid = :tid");
            paramMap.put("tid", tid);
        }
        if (null != epc && !"".equals(epc)) {
            sql.append(" AND ati.epc = :epc");
            paramMap.put("epc", epc);
        }
        sql.append(" ORDER BY ach.id ASC");
        sql.append(" OFFSET " + (pageIndex - 1) * pageSize + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY");
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(AlsCsvTidReportInfo.class));
    }

    @Override
    public List<AlsCsvFileHeader> getAlsCsvFileHeaderByCon(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate, String ticketCenterId, String deviceBrand, String deviceType, String controllerHostName, String controllerUserName) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT id, production_date, sales_order_number, ord_seq, bat_seq, gtin, org_id, table_name,");
        sql.append(" epc_lock, kill_pwd_lock, access_pwd_lock, user_mem_lock, tid_lock, print_job_id, ticket_center_id, device_brand,");
        sql.append(" device_type, device_internal_name, device_serial_number, device_controller_software_version, controller_host_name, controller_user_name");
        sql.append(" FROM als_csv_header_hist");
        sql.append(" WHERE 1 = 1");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND retailer_name LIKE '%" + retailerName + "%'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != ticketCenterId && !"".equals(ticketCenterId)) {
            sql.append(" AND ticket_center_id = :ticketCenterId");
            paramMap.put("ticketCenterId", ticketCenterId);
        }
        if (null != deviceBrand && !"".equals(deviceBrand)) {
            sql.append(" AND device_brand = :deviceBrand");
            paramMap.put("deviceBrand", deviceBrand);
        }
        if (null != deviceType && !"".equals(deviceType)) {
            sql.append(" AND device_type = :deviceType");
            paramMap.put("deviceType", deviceType);
        }
        if (null != controllerHostName && !"".equals(controllerHostName)) {
            sql.append(" AND controller_host_name = :controllerHostName");
            paramMap.put("controllerHostName", controllerHostName);
        }
        if (null != controllerUserName && !"".equals(controllerUserName)) {
            sql.append(" AND controller_user_name = :controllerUserName");
            paramMap.put("controllerUserName", controllerUserName);
        }
        if (null != startProductionDate) {
            sql.append(" AND production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        return this.parameterJdbcTemplate.query(sql.toString(), paramMap, (RowMapper)new BeanPropertyRowMapper(AlsCsvFileHeader.class));
    }

    @Override
    public int countAlsTidReportWithPage(String orgId, String retailerName, String ordSeq, String salesOrderNumber, String gtin, Date startProductionDate, Date endProductionDate, String tableName, String tid, String epc, String ticketCenterId, String deviceBrand, String deviceType, String controllerHostName, String controllerUserName) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sql.append("SELECT COUNT(1)");
        sql.append(" FROM als_csv_header_hist ach");
        sql.append(" LEFT JOIN " + tableName + " ati ON ati.als_header_id = ach.id");
        sql.append(" LEFT JOIN tid_bind_roll tbr ON tbr.id = ati.roll_id");
        sql.append(" WHERE ati.als_header_id = ach.id");
        if (null != orgId && !"".equals(orgId)) {
            sql.append(" AND ach.org_id = :orgId");
            paramMap.put("orgId", orgId);
        }
        if (null != retailerName && !"".equals(retailerName)) {
            sql.append(" AND ach.retailer_name LIKE '" + retailerName + "'");
        }
        if (null != ordSeq && !"".equals(ordSeq)) {
            sql.append(" AND ach.ord_seq = :ordSeq");
            paramMap.put("ordSeq", ordSeq);
        }
        if (null != salesOrderNumber && !"".equals(salesOrderNumber)) {
            sql.append(" AND ach.sales_order_number = :salesOrderNumber");
            paramMap.put("salesOrderNumber", salesOrderNumber);
        }
        if (null != gtin && !"".equals(gtin)) {
            sql.append(" AND ach.gtin = :gtin");
            paramMap.put("gtin", gtin);
        }
        if (null != ticketCenterId && !"".equals(ticketCenterId)) {
            sql.append(" AND ach.ticket_center_id = :ticketCenterId");
            paramMap.put("ticketCenterId", ticketCenterId);
        }
        if (null != deviceBrand && !"".equals(deviceBrand)) {
            sql.append(" AND ach.device_brand = :deviceBrand");
            paramMap.put("deviceBrand", deviceBrand);
        }
        if (null != deviceType && !"".equals(deviceType)) {
            sql.append(" AND ach.device_type = :deviceType");
            paramMap.put("deviceType", deviceType);
        }
        if (null != controllerHostName && !"".equals(controllerHostName)) {
            sql.append(" AND ach.controller_host_name = :controllerHostName");
            paramMap.put("controllerHostName", controllerHostName);
        }
        if (null != controllerUserName && !"".equals(controllerUserName)) {
            sql.append(" AND ach.controller_user_name = :controllerUserName");
            paramMap.put("controllerUserName", controllerUserName);
        }
        if (null != startProductionDate) {
            sql.append(" AND ach.production_date >= :startProductionDate");
            paramMap.put("startProductionDate", startProductionDate);
        }
        if (null != endProductionDate) {
            sql.append(" AND ach.production_date <= :endProductionDate");
            paramMap.put("endProductionDate", endProductionDate);
        }
        if (null != tid && !"".equals(tid)) {
            sql.append(" AND ati.tid = :tid");
            paramMap.put("tid", tid);
        }
        if (null != epc && !"".equals(epc)) {
            sql.append(" AND ati.epc = :epc");
            paramMap.put("epc", epc);
        }
        return (Integer)this.parameterJdbcTemplate.queryForObject(sql.toString(), paramMap, Integer.class);
    }
}

