/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.base.controller;

import com.gaotao.common.utils.R;
import com.gaotao.modules.base.entity.Chooselist;
import com.gaotao.modules.base.service.ChooselistService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"chooselist"})
public class ChooselistController {
    @Autowired
    private ChooselistService chooselistService;

    @GetMapping(value={"getChooselist/{tagNo}"})
    public R getChooselist(@PathVariable(value="tagNo") String tagNo) {
        Chooselist chooselist = this.chooselistService.getChooselist(tagNo);
        return R.ok().put("data", (Object)chooselist);
    }

    @PostMapping(value={"getChooselistData"})
    public R getChooselistData(@RequestBody Chooselist chooselist) {
        List<Map<String, Map<String, Object>>> baseListData = this.chooselistService.getChooselistData(chooselist.getSqlcode());
        if (!CollectionUtils.isEmpty(baseListData) && baseListData.size() >= 200) {
            return R.ok().put("baseListData", (Object)baseListData.subList(0, 200));
        }
        return R.ok().put("baseListData", (Object)baseListData);
    }
}

