/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.LocalDate;
import com.microsoft.sqlserver.jdbc.LocalDateTime;
import com.microsoft.sqlserver.jdbc.LocalTime;
import com.microsoft.sqlserver.jdbc.OffsetDateTime;
import com.microsoft.sqlserver.jdbc.OffsetTime;
import com.microsoft.sqlserver.jdbc.ReaderInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SQLServerSecurityUtility;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSType;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TVP;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.UTC;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import microsoft.sql.DateTimeOffset;

final class DTV {
    private static final Logger aeLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.DTV");
    private DTVImpl impl;
    CryptoMetadata cryptoMeta = null;
    JDBCType jdbcTypeSetByUser = null;
    int valueLength = 0;

    DTV() {
    }

    void setValue(SQLCollation sQLCollation, JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection, boolean bl) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new AppDTVImpl();
        }
        this.impl.setValue(this, sQLCollation, jDBCType, object, javaType, streamSetterArgs, calendar, n, sQLServerConnection, bl);
    }

    final void setValue(Object object, JavaType javaType) {
        this.impl.setValue(object, javaType);
    }

    final void clear() {
        this.impl = null;
    }

    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        this.impl.skipValue(typeInfo, tDSReader, bl);
    }

    final void initFromCompressedNull() {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        this.impl.initFromCompressedNull();
    }

    final void setStreamSetterArgs(StreamSetterArgs streamSetterArgs) {
        this.impl.setStreamSetterArgs(streamSetterArgs);
    }

    final void setCalendar(Calendar calendar) {
        this.impl.setCalendar(calendar);
    }

    final void setScale(Integer n) {
        this.impl.setScale(n);
    }

    final void setForceEncrypt(boolean bl) {
        this.impl.setForceEncrypt(bl);
    }

    StreamSetterArgs getStreamSetterArgs() {
        return this.impl.getStreamSetterArgs();
    }

    Calendar getCalendar() {
        return this.impl.getCalendar();
    }

    Integer getScale() {
        return this.impl.getScale();
    }

    boolean isNull() {
        return null == this.impl || this.impl.isNull();
    }

    final boolean isInitialized() {
        return null != this.impl;
    }

    final void setJdbcType(JDBCType jDBCType) {
        if (null == this.impl) {
            this.impl = new AppDTVImpl();
        }
        this.impl.setJdbcType(jDBCType);
    }

    final JDBCType getJdbcType() {
        assert (null != this.impl);
        return this.impl.getJdbcType();
    }

    final JavaType getJavaType() {
        assert (null != this.impl);
        return this.impl.getJavaType();
    }

    Object getValue(JDBCType jDBCType, int n, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, CryptoMetadata cryptoMetadata, TDSReader tDSReader) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return this.impl.getValue(this, jDBCType, n, inputStreamGetterArgs, calendar, typeInfo, cryptoMetadata, tDSReader);
    }

    Object getSetterValue() {
        return this.impl.getSetterValue();
    }

    void setImpl(DTVImpl dTVImpl) {
        this.impl = dTVImpl;
    }

    final void executeOp(DTVExecuteOp dTVExecuteOp) throws SQLServerException {
        Object object;
        JDBCType jDBCType = this.getJdbcType();
        Object object2 = this.getSetterValue();
        JavaType javaType = this.getJavaType();
        boolean bl = false;
        byte[] byArray = null;
        if (null != this.cryptoMeta && !JavaType.SetterConversionAE.converts(javaType, jDBCType)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionAE"));
            Object[] objectArray = new Object[]{javaType.toString().toLowerCase(Locale.ENGLISH), jDBCType.toString().toLowerCase(Locale.ENGLISH)};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        if (null == object2) {
            switch (jDBCType) {
                case NCHAR: 
                case NVARCHAR: 
                case LONGNVARCHAR: 
                case NCLOB: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (String)null);
                    break;
                }
                case INTEGER: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Integer)null);
                    break;
                }
                case DATE: {
                    dTVExecuteOp.execute(this, (Date)null);
                    break;
                }
                case TIME: {
                    dTVExecuteOp.execute(this, (Time)null);
                    break;
                }
                case DATETIME: 
                case SMALLDATETIME: 
                case TIMESTAMP: {
                    dTVExecuteOp.execute(this, (Timestamp)null);
                    break;
                }
                case TIMESTAMP_WITH_TIMEZONE: 
                case DATETIMEOFFSET: 
                case TIME_WITH_TIMEZONE: {
                    dTVExecuteOp.execute(this, (DateTimeOffset)null);
                    break;
                }
                case FLOAT: 
                case REAL: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Float)null);
                    break;
                }
                case NUMERIC: 
                case DECIMAL: 
                case MONEY: 
                case SMALLMONEY: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (BigDecimal)null);
                    break;
                }
                case BINARY: 
                case VARBINARY: 
                case LONGVARBINARY: 
                case BLOB: 
                case CHAR: 
                case VARCHAR: 
                case LONGVARCHAR: 
                case CLOB: 
                case GUID: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (byte[])null);
                    break;
                }
                case TINYINT: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Byte)null);
                    break;
                }
                case BIGINT: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Long)null);
                    break;
                }
                case DOUBLE: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Double)null);
                    break;
                }
                case SMALLINT: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Short)null);
                    break;
                }
                case BIT: 
                case BOOLEAN: {
                    if (null != this.cryptoMeta) {
                        dTVExecuteOp.execute(this, (byte[])null);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Boolean)null);
                    break;
                }
                case SQLXML: {
                    dTVExecuteOp.execute(this, (SQLServerSQLXML)null);
                    break;
                }
                case ARRAY: 
                case DATALINK: 
                case DISTINCT: 
                case JAVA_OBJECT: 
                case NULL: 
                case OTHER: 
                case REF: 
                case ROWID: 
                case STRUCT: {
                    bl = true;
                    break;
                }
                default: {
                    assert (false) : "Unexpected JDBCType: " + (Object)((Object)jDBCType);
                    bl = true;
                    break;
                }
            }
        } else {
            if (aeLogger.isLoggable(Level.FINE) && null != this.cryptoMeta) {
                aeLogger.fine("Encrypting java data type: " + (Object)((Object)javaType));
            }
            switch (javaType) {
                case STRING: {
                    if (JDBCType.GUID == jDBCType) {
                        if (object2 instanceof String) {
                            object2 = UUID.fromString((String)object2);
                        }
                        object = Util.asGuidByteArray((UUID)object2);
                        dTVExecuteOp.execute(this, (byte[])object);
                        break;
                    }
                    if (null != this.cryptoMeta) {
                        if (jDBCType == JDBCType.LONGNVARCHAR && JDBCType.VARCHAR == this.jdbcTypeSetByUser && Integer.MAX_VALUE < this.valueLength) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_StreamingDataTypeAE"));
                            Object[] objectArray = new Object[]{Integer.MAX_VALUE, JDBCType.LONGVARCHAR};
                            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                        }
                        if (JDBCType.NVARCHAR == this.jdbcTypeSetByUser && 0x3FFFFFFF < this.valueLength) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_StreamingDataTypeAE"));
                            Object[] objectArray = new Object[]{0x3FFFFFFF, JDBCType.LONGNVARCHAR};
                            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                        }
                        if (JDBCType.NVARCHAR == this.jdbcTypeSetByUser || JDBCType.NCHAR == this.jdbcTypeSetByUser || JDBCType.LONGNVARCHAR == this.jdbcTypeSetByUser) {
                            byArray = ((String)object2).getBytes(Charset.forName("UTF-16LE"));
                        } else if (JDBCType.VARCHAR == this.jdbcTypeSetByUser || JDBCType.CHAR == this.jdbcTypeSetByUser || JDBCType.LONGVARCHAR == this.jdbcTypeSetByUser) {
                            byArray = ((String)object2).getBytes();
                        }
                        dTVExecuteOp.execute(this, byArray);
                        break;
                    }
                    dTVExecuteOp.execute(this, (String)object2);
                    break;
                }
                case INTEGER: {
                    if (null != this.cryptoMeta) {
                        byArray = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(((Integer)object2).longValue()).array();
                        dTVExecuteOp.execute(this, byArray);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Integer)object2);
                    break;
                }
                case DATE: {
                    dTVExecuteOp.execute(this, (Date)object2);
                    break;
                }
                case TIME: {
                    dTVExecuteOp.execute(this, (Time)object2);
                    break;
                }
                case TIMESTAMP: {
                    if (JDBCType.SMALLDATETIME == jDBCType && (((Timestamp)(object = (Timestamp)object2)).after(TDS.MAX_TIMESTAMP) || ((Timestamp)object).before(TDS.MIN_TIMESTAMP))) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
                        throw new SQLServerException(messageFormat.format(new Object[]{jDBCType}), null, 0, null);
                    }
                    dTVExecuteOp.execute(this, (Timestamp)object2);
                    break;
                }
                case TVP: {
                    dTVExecuteOp.execute(this, (TVP)object2);
                    break;
                }
                case UTILDATE: {
                    dTVExecuteOp.execute(this, (java.util.Date)object2);
                    break;
                }
                case CALENDAR: {
                    dTVExecuteOp.execute(this, (Calendar)object2);
                    break;
                }
                case LOCALDATE: {
                    dTVExecuteOp.execute(this, (LocalDate)object2);
                    break;
                }
                case LOCALTIME: {
                    dTVExecuteOp.execute(this, (LocalTime)object2);
                    break;
                }
                case LOCALDATETIME: {
                    dTVExecuteOp.execute(this, (LocalDateTime)object2);
                    break;
                }
                case OFFSETTIME: {
                    dTVExecuteOp.execute(this, (OffsetTime)object2);
                    break;
                }
                case OFFSETDATETIME: {
                    dTVExecuteOp.execute(this, (OffsetDateTime)object2);
                    break;
                }
                case DATETIMEOFFSET: {
                    dTVExecuteOp.execute(this, (DateTimeOffset)object2);
                    break;
                }
                case FLOAT: {
                    if (null != this.cryptoMeta) {
                        if (Float.isInfinite(((Float)object2).floatValue())) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
                            throw new SQLServerException(messageFormat.format(new Object[]{jDBCType}), null, 0, null);
                        }
                        byArray = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(((Float)object2).floatValue()).array();
                        dTVExecuteOp.execute(this, byArray);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Float)object2);
                    break;
                }
                case BIGDECIMAL: {
                    if (null != this.cryptoMeta) {
                        if (JDBCType.MONEY == jDBCType || JDBCType.SMALLMONEY == jDBCType) {
                            object = (BigDecimal)object2;
                            Util.validateMoneyRange((BigDecimal)object, jDBCType);
                            int n = Math.max(((BigDecimal)object).precision() - ((BigDecimal)object).scale(), 0) + 4;
                            long l = ((BigDecimal)object2).multiply(new BigDecimal(10000), new MathContext(n, RoundingMode.HALF_UP)).longValue();
                            ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
                            byteBuffer.putInt((int)(l >> 32)).array();
                            byteBuffer.putInt((int)l).array();
                            dTVExecuteOp.execute(this, byteBuffer.array());
                            break;
                        }
                        object = (BigDecimal)object2;
                        byte[] byArray2 = DDC.convertBigDecimalToBytes((BigDecimal)object, ((BigDecimal)object).scale());
                        byArray = new byte[16];
                        System.arraycopy(byArray2, 2, byArray, 0, byArray2.length - 2);
                        this.setScale(((BigDecimal)object).scale());
                        dTVExecuteOp.execute(this, byArray);
                        break;
                    }
                    dTVExecuteOp.execute(this, (BigDecimal)object2);
                    break;
                }
                case BYTEARRAY: {
                    if (null != this.cryptoMeta && Integer.MAX_VALUE < this.valueLength) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_StreamingDataTypeAE"));
                        Object[] objectArray = new Object[]{Integer.MAX_VALUE, JDBCType.BINARY};
                        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                    }
                    dTVExecuteOp.execute(this, (byte[])object2);
                    break;
                }
                case BYTE: {
                    if (null != this.cryptoMeta) {
                        byArray = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong((long)((Byte)object2 & 0xFF)).array();
                        dTVExecuteOp.execute(this, byArray);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Byte)object2);
                    break;
                }
                case LONG: {
                    if (null != this.cryptoMeta) {
                        byArray = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong((Long)object2).array();
                        dTVExecuteOp.execute(this, byArray);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Long)object2);
                    break;
                }
                case BIGINTEGER: {
                    dTVExecuteOp.execute(this, (BigInteger)object2);
                    break;
                }
                case DOUBLE: {
                    if (null != this.cryptoMeta) {
                        if (Double.isInfinite((Double)object2)) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
                            throw new SQLServerException(messageFormat.format(new Object[]{jDBCType}), null, 0, null);
                        }
                        byArray = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble((Double)object2).array();
                        dTVExecuteOp.execute(this, byArray);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Double)object2);
                    break;
                }
                case SHORT: {
                    if (null != this.cryptoMeta) {
                        byArray = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(((Short)object2).shortValue()).array();
                        dTVExecuteOp.execute(this, byArray);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Short)object2);
                    break;
                }
                case BOOLEAN: {
                    if (null != this.cryptoMeta) {
                        byArray = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong((Boolean)object2 != false ? 1L : 0L).array();
                        dTVExecuteOp.execute(this, byArray);
                        break;
                    }
                    dTVExecuteOp.execute(this, (Boolean)object2);
                    break;
                }
                case BLOB: {
                    dTVExecuteOp.execute(this, (Blob)object2);
                    break;
                }
                case CLOB: 
                case NCLOB: {
                    dTVExecuteOp.execute(this, (Clob)object2);
                    break;
                }
                case INPUTSTREAM: {
                    dTVExecuteOp.execute(this, (InputStream)object2);
                    break;
                }
                case READER: {
                    dTVExecuteOp.execute(this, (Reader)object2);
                    break;
                }
                case SQLXML: {
                    dTVExecuteOp.execute(this, (SQLServerSQLXML)object2);
                    break;
                }
                default: {
                    assert (false) : "Unexpected JavaType: " + (Object)((Object)javaType);
                    bl = true;
                }
            }
        }
        if (bl) {
            object = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{javaType, jDBCType};
            throw new SQLServerException(((Format)object).format(objectArray), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
    }

    void sendCryptoMetaData(CryptoMetadata cryptoMetadata, TDSWriter tDSWriter) {
        this.cryptoMeta = cryptoMetadata;
        tDSWriter.setCryptoMetaData(cryptoMetadata);
    }

    void jdbcTypeSetByUser(JDBCType jDBCType, int n) {
        this.jdbcTypeSetByUser = jDBCType;
        this.valueLength = n;
    }

    void sendByRPC(String string, TypeInfo typeInfo, SQLCollation sQLCollation, int n, int n2, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) throws SQLServerException {
        this.executeOp(new SendByRPCOp(string, typeInfo, sQLCollation, n, n2, bl, tDSWriter, sQLServerConnection));
    }

    final class SendByRPCOp
    extends DTVExecuteOp {
        private final String name;
        private final TypeInfo typeInfo;
        private final SQLCollation collation;
        private final int precision;
        private final int outScale;
        private final boolean isOutParam;
        private final TDSWriter tdsWriter;
        private final SQLServerConnection conn;

        SendByRPCOp(String string, TypeInfo typeInfo, SQLCollation sQLCollation, int n, int n2, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) {
            this.name = string;
            this.typeInfo = typeInfo;
            this.collation = sQLCollation;
            this.precision = n;
            this.outScale = n2;
            this.isOutParam = bl;
            this.tdsWriter = tDSWriter;
            this.conn = sQLServerConnection;
        }

        @Override
        void execute(DTV dTV, String string) throws SQLServerException {
            this.tdsWriter.writeRPCStringUnicode(this.name, string, this.isOutParam, this.collation);
        }

        @Override
        void execute(DTV dTV, Clob clob) throws SQLServerException {
            assert (null != clob);
            long l = 0L;
            Reader reader = null;
            try {
                l = DataTypes.getCheckedLength(this.conn, dTV.getJdbcType(), clob.length(), false);
                reader = clob.getCharacterStream();
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.conn, null, sQLException.getMessage(), null, false);
            }
            JDBCType jDBCType = dTV.getJdbcType();
            if (null != this.collation && (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.LONGVARCHAR == jDBCType || JDBCType.CLOB == jDBCType)) {
                if (null == reader) {
                    this.tdsWriter.writeRPCByteArray(this.name, null, this.isOutParam, jDBCType, this.collation);
                } else {
                    ReaderInputStream readerInputStream = null;
                    try {
                        readerInputStream = new ReaderInputStream(reader, this.collation.getCharset(), l);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                        Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                        SQLServerException.makeFromDriverError(this.conn, null, messageFormat.format(objectArray), null, true);
                    }
                    this.tdsWriter.writeRPCInputStream(this.name, readerInputStream, -1L, this.isOutParam, jDBCType, this.collation);
                }
            } else if (null == reader) {
                this.tdsWriter.writeRPCStringUnicode(this.name, null, this.isOutParam, this.collation);
            } else {
                this.tdsWriter.writeRPCReaderUnicode(this.name, reader, l, this.isOutParam, this.collation);
            }
        }

        @Override
        void execute(DTV dTV, Byte by) throws SQLServerException {
            this.tdsWriter.writeRPCByte(this.name, by, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Integer n) throws SQLServerException {
            this.tdsWriter.writeRPCInt(this.name, n, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Time time) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.TIME, time);
        }

        @Override
        void execute(DTV dTV, Date date) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.DATE, date);
        }

        @Override
        void execute(DTV dTV, Timestamp timestamp) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.TIMESTAMP, timestamp);
        }

        @Override
        void execute(DTV dTV, java.util.Date date) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.UTILDATE, date);
        }

        @Override
        void execute(DTV dTV, Calendar calendar) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.CALENDAR, calendar);
        }

        @Override
        void execute(DTV dTV, LocalDate localDate) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.LOCALDATE, localDate);
        }

        @Override
        void execute(DTV dTV, LocalTime localTime) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.LOCALTIME, localTime);
        }

        @Override
        void execute(DTV dTV, LocalDateTime localDateTime) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.LOCALDATETIME, localDateTime);
        }

        @Override
        void execute(DTV dTV, OffsetTime offsetTime) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.OFFSETTIME, offsetTime);
        }

        @Override
        void execute(DTV dTV, OffsetDateTime offsetDateTime) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.OFFSETDATETIME, offsetDateTime);
        }

        @Override
        void execute(DTV dTV, DateTimeOffset dateTimeOffset) throws SQLServerException {
            this.sendTemporal(dTV, JavaType.DATETIMEOFFSET, dateTimeOffset);
        }

        @Override
        void execute(DTV dTV, TVP tVP) throws SQLServerException {
            this.tdsWriter.writeTVP(tVP);
        }

        private void clearSetCalendar(Calendar calendar, boolean bl, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6) {
            calendar.clear();
            calendar.setLenient(bl);
            if (null != n) {
                calendar.set(1, n);
            }
            if (null != n2) {
                calendar.set(2, n2);
            }
            if (null != n3) {
                calendar.set(5, n3);
            }
            if (null != n4) {
                calendar.set(11, n4);
            }
            if (null != n5) {
                calendar.set(12, n5);
            }
            if (null != n6) {
                calendar.set(13, n6);
            }
        }

        private void sendTemporal(DTV dTV, JavaType javaType, Object object) throws SQLServerException {
            block74: {
                int n;
                GregorianCalendar gregorianCalendar;
                JDBCType jDBCType;
                block75: {
                    int n2;
                    block73: {
                        jDBCType = dTV.getJdbcType();
                        gregorianCalendar = null;
                        n = 0;
                        n2 = 0;
                        if (null != object) {
                            TimeZone timeZone = TimeZone.getDefault();
                            long l = 0L;
                            switch (javaType) {
                                case TIME: {
                                    timeZone = null != dTV.getCalendar() ? dTV.getCalendar().getTimeZone() : TimeZone.getDefault();
                                    l = ((Time)object).getTime();
                                    n = 1000000 * (int)(l % 1000L);
                                    if (n >= 0) break;
                                    n += 1000000000;
                                    break;
                                }
                                case DATE: {
                                    timeZone = null != dTV.getCalendar() ? dTV.getCalendar().getTimeZone() : TimeZone.getDefault();
                                    l = ((Date)object).getTime();
                                    break;
                                }
                                case TIMESTAMP: {
                                    timeZone = null != dTV.getCalendar() ? dTV.getCalendar().getTimeZone() : TimeZone.getDefault();
                                    Timestamp timestamp = (Timestamp)object;
                                    l = timestamp.getTime();
                                    n = timestamp.getNanos();
                                    break;
                                }
                                case UTILDATE: {
                                    timeZone = null != dTV.getCalendar() ? dTV.getCalendar().getTimeZone() : TimeZone.getDefault();
                                    l = ((java.util.Date)object).getTime();
                                    n = 1000000 * (int)(l % 1000L);
                                    if (n >= 0) break;
                                    n += 1000000000;
                                    break;
                                }
                                case CALENDAR: {
                                    timeZone = null != dTV.getCalendar() ? dTV.getCalendar().getTimeZone() : TimeZone.getDefault();
                                    l = ((Calendar)object).getTimeInMillis();
                                    n = 1000000 * (int)(l % 1000L);
                                    if (n >= 0) break;
                                    n += 1000000000;
                                    break;
                                }
                                case LOCALDATE: {
                                    gregorianCalendar = new GregorianCalendar(UTC.timeZone, Locale.US);
                                    this.clearSetCalendar(gregorianCalendar, true, ((LocalDate)object).getYear(), ((LocalDate)object).getMonthValue() - 1, ((LocalDate)object).getDayOfMonth(), null, null, null);
                                    break;
                                }
                                case LOCALTIME: {
                                    gregorianCalendar = new GregorianCalendar(UTC.timeZone, Locale.US);
                                    LocalTime localTime = (LocalTime)object;
                                    this.clearSetCalendar(gregorianCalendar, true, this.conn.baseYear(), 1, 1, localTime.getHour(), localTime.getMinute(), localTime.getSecond());
                                    n = localTime.getNano();
                                    break;
                                }
                                case LOCALDATETIME: {
                                    gregorianCalendar = new GregorianCalendar(UTC.timeZone, Locale.US);
                                    LocalDateTime localDateTime = (LocalDateTime)object;
                                    this.clearSetCalendar(gregorianCalendar, true, localDateTime.getYear(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
                                    n = localDateTime.getNano();
                                    break;
                                }
                                case OFFSETTIME: {
                                    OffsetTime offsetTime = (OffsetTime)object;
                                    try {
                                        n2 = offsetTime.getOffset().getTotalSeconds() / 60;
                                    }
                                    catch (Exception exception) {
                                        throw new SQLServerException(SQLServerException.getErrString("R_zoneOffsetError"), null, 0, null);
                                    }
                                    n = offsetTime.getNano();
                                    timeZone = JDBCType.TIME_WITH_TIMEZONE == jDBCType && (null == this.typeInfo || SSType.DATETIMEOFFSET == this.typeInfo.getSSType()) ? UTC.timeZone : new SimpleTimeZone(n2 * 60 * 1000, "");
                                    String string = this.conn.baseYear() + "-01-01" + ' ' + offsetTime.getHour() + ':' + offsetTime.getMinute() + ':' + offsetTime.getSecond();
                                    l = Timestamp.valueOf(string).getTime();
                                    break;
                                }
                                case OFFSETDATETIME: {
                                    OffsetDateTime offsetDateTime = (OffsetDateTime)object;
                                    try {
                                        n2 = offsetDateTime.getOffset().getTotalSeconds() / 60;
                                    }
                                    catch (Exception exception) {
                                        throw new SQLServerException(SQLServerException.getErrString("R_zoneOffsetError"), null, 0, null);
                                    }
                                    n = offsetDateTime.getNano();
                                    timeZone = !(JDBCType.TIMESTAMP_WITH_TIMEZONE != jDBCType && JDBCType.TIME_WITH_TIMEZONE != jDBCType || null != this.typeInfo && SSType.DATETIMEOFFSET != this.typeInfo.getSSType()) ? UTC.timeZone : new SimpleTimeZone(n2 * 60 * 1000, "");
                                    String string = String.format("%04d", offsetDateTime.getYear()) + '-' + offsetDateTime.getMonthValue() + '-' + offsetDateTime.getDayOfMonth() + ' ' + offsetDateTime.getHour() + ':' + offsetDateTime.getMinute() + ':' + offsetDateTime.getSecond();
                                    l = Timestamp.valueOf(string).getTime();
                                    break;
                                }
                                case DATETIMEOFFSET: {
                                    DateTimeOffset dateTimeOffset = (DateTimeOffset)object;
                                    l = dateTimeOffset.getTimestamp().getTime();
                                    n = dateTimeOffset.getTimestamp().getNanos();
                                    n2 = dateTimeOffset.getMinutesOffset();
                                    assert (null == dTV.getCalendar());
                                    timeZone = JDBCType.DATETIMEOFFSET == jDBCType && (null == this.typeInfo || SSType.DATETIMEOFFSET == this.typeInfo.getSSType() || SSType.VARBINARY == this.typeInfo.getSSType() || SSType.VARBINARYMAX == this.typeInfo.getSSType()) ? UTC.timeZone : new SimpleTimeZone(n2 * 60 * 1000, "");
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("Unexpected JavaType: " + (Object)((Object)javaType)));
                                }
                            }
                            if (null == gregorianCalendar) {
                                gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
                                gregorianCalendar.setLenient(true);
                                gregorianCalendar.clear();
                                gregorianCalendar.setTimeInMillis(l);
                            }
                        }
                        if (null == this.typeInfo) break block73;
                        switch (this.typeInfo.getSSType()) {
                            case DATETIME2: {
                                this.tdsWriter.writeRPCDateTime2(this.name, this.timestampNormalizedCalendar(gregorianCalendar, javaType, this.conn.baseYear()), n, this.typeInfo.getScale(), this.isOutParam);
                                break block74;
                            }
                            case DATE: {
                                this.tdsWriter.writeRPCDate(this.name, gregorianCalendar, this.isOutParam);
                                break block74;
                            }
                            case TIME: {
                                this.tdsWriter.writeRPCTime(this.name, gregorianCalendar, n, this.typeInfo.getScale(), this.isOutParam);
                                break block74;
                            }
                            case DATETIMEOFFSET: {
                                if (JavaType.DATETIMEOFFSET != javaType) {
                                    gregorianCalendar = this.timestampNormalizedCalendar(this.localCalendarAsUTC(gregorianCalendar), javaType, this.conn.baseYear());
                                    n2 = 0;
                                }
                                this.tdsWriter.writeRPCDateTimeOffset(this.name, gregorianCalendar, n2, n, this.typeInfo.getScale(), this.isOutParam);
                                break block74;
                            }
                            case DATETIME: 
                            case SMALLDATETIME: {
                                this.tdsWriter.writeRPCDateTime(this.name, this.timestampNormalizedCalendar(gregorianCalendar, javaType, this.conn.baseYear()), n, this.isOutParam);
                                break block74;
                            }
                            case VARBINARY: 
                            case VARBINARYMAX: {
                                switch (jDBCType) {
                                    case DATETIME: 
                                    case SMALLDATETIME: {
                                        this.tdsWriter.writeEncryptedRPCDateTime(this.name, this.timestampNormalizedCalendar(gregorianCalendar, javaType, this.conn.baseYear()), n, this.isOutParam, jDBCType);
                                        break block74;
                                    }
                                    case TIMESTAMP: {
                                        assert (null != DTV.this.cryptoMeta);
                                        this.tdsWriter.writeEncryptedRPCDateTime2(this.name, this.timestampNormalizedCalendar(gregorianCalendar, javaType, this.conn.baseYear()), n, DTV.this.valueLength, this.isOutParam);
                                        break block74;
                                    }
                                    case TIME: {
                                        assert (null != DTV.this.cryptoMeta);
                                        this.tdsWriter.writeEncryptedRPCTime(this.name, gregorianCalendar, n, DTV.this.valueLength, this.isOutParam);
                                        break block74;
                                    }
                                    case DATE: {
                                        assert (null != DTV.this.cryptoMeta);
                                        this.tdsWriter.writeEncryptedRPCDate(this.name, gregorianCalendar, this.isOutParam);
                                        break block74;
                                    }
                                    case TIMESTAMP_WITH_TIMEZONE: 
                                    case DATETIMEOFFSET: {
                                        if (JavaType.DATETIMEOFFSET != javaType && JavaType.OFFSETDATETIME != javaType) {
                                            gregorianCalendar = this.timestampNormalizedCalendar(this.localCalendarAsUTC(gregorianCalendar), javaType, this.conn.baseYear());
                                            n2 = 0;
                                        }
                                        assert (null != DTV.this.cryptoMeta);
                                        this.tdsWriter.writeEncryptedRPCDateTimeOffset(this.name, gregorianCalendar, n2, n, DTV.this.valueLength, this.isOutParam);
                                        break block74;
                                    }
                                    default: {
                                        assert (false) : "Unexpected JDBCType: " + (Object)((Object)jDBCType);
                                        break block74;
                                    }
                                }
                            }
                            default: {
                                assert (false) : "Unexpected SSType: " + (Object)((Object)this.typeInfo.getSSType());
                                break block74;
                            }
                        }
                    }
                    if (!this.conn.isKatmaiOrLater()) break block75;
                    if (aeLogger.isLoggable(Level.FINE) && null != DTV.this.cryptoMeta) {
                        aeLogger.fine("Encrypting temporal data type.");
                    }
                    switch (jDBCType) {
                        case DATETIME: 
                        case SMALLDATETIME: 
                        case TIMESTAMP: {
                            if (null != DTV.this.cryptoMeta) {
                                if (JDBCType.DATETIME == jDBCType || JDBCType.SMALLDATETIME == jDBCType) {
                                    this.tdsWriter.writeEncryptedRPCDateTime(this.name, this.timestampNormalizedCalendar(gregorianCalendar, javaType, this.conn.baseYear()), n, this.isOutParam, jDBCType);
                                } else if (0 == DTV.this.valueLength) {
                                    this.tdsWriter.writeEncryptedRPCDateTime2(this.name, this.timestampNormalizedCalendar(gregorianCalendar, javaType, this.conn.baseYear()), n, this.outScale, this.isOutParam);
                                } else {
                                    this.tdsWriter.writeEncryptedRPCDateTime2(this.name, this.timestampNormalizedCalendar(gregorianCalendar, javaType, this.conn.baseYear()), n, DTV.this.valueLength, this.isOutParam);
                                }
                            } else {
                                this.tdsWriter.writeRPCDateTime2(this.name, this.timestampNormalizedCalendar(gregorianCalendar, javaType, this.conn.baseYear()), n, 7, this.isOutParam);
                            }
                            break block74;
                        }
                        case TIME: {
                            if (null != DTV.this.cryptoMeta) {
                                if (0 == DTV.this.valueLength) {
                                    this.tdsWriter.writeEncryptedRPCTime(this.name, gregorianCalendar, n, this.outScale, this.isOutParam);
                                } else {
                                    this.tdsWriter.writeEncryptedRPCTime(this.name, gregorianCalendar, n, DTV.this.valueLength, this.isOutParam);
                                }
                            } else if (this.conn.getSendTimeAsDatetime()) {
                                this.tdsWriter.writeRPCDateTime(this.name, this.timestampNormalizedCalendar(gregorianCalendar, JavaType.TIME, 1970), n, this.isOutParam);
                            } else {
                                this.tdsWriter.writeRPCTime(this.name, gregorianCalendar, n, 7, this.isOutParam);
                            }
                            break block74;
                        }
                        case DATE: {
                            if (null != DTV.this.cryptoMeta) {
                                this.tdsWriter.writeEncryptedRPCDate(this.name, gregorianCalendar, this.isOutParam);
                            } else {
                                this.tdsWriter.writeRPCDate(this.name, gregorianCalendar, this.isOutParam);
                            }
                            break block74;
                        }
                        case TIME_WITH_TIMEZONE: {
                            if (JavaType.OFFSETDATETIME != javaType && JavaType.OFFSETTIME != javaType) {
                                gregorianCalendar = this.timestampNormalizedCalendar(this.localCalendarAsUTC(gregorianCalendar), javaType, this.conn.baseYear());
                                n2 = 0;
                            }
                            this.tdsWriter.writeRPCDateTimeOffset(this.name, gregorianCalendar, n2, n, 7, this.isOutParam);
                            break block74;
                        }
                        case TIMESTAMP_WITH_TIMEZONE: 
                        case DATETIMEOFFSET: {
                            if (JavaType.DATETIMEOFFSET != javaType && JavaType.OFFSETDATETIME != javaType) {
                                gregorianCalendar = this.timestampNormalizedCalendar(this.localCalendarAsUTC(gregorianCalendar), javaType, this.conn.baseYear());
                                n2 = 0;
                            }
                            if (null != DTV.this.cryptoMeta) {
                                if (0 == DTV.this.valueLength) {
                                    this.tdsWriter.writeEncryptedRPCDateTimeOffset(this.name, gregorianCalendar, n2, n, this.outScale, this.isOutParam);
                                } else {
                                    this.tdsWriter.writeEncryptedRPCDateTimeOffset(this.name, gregorianCalendar, n2, n, 0 == DTV.this.valueLength ? 7 : DTV.this.valueLength, this.isOutParam);
                                }
                            } else {
                                this.tdsWriter.writeRPCDateTimeOffset(this.name, gregorianCalendar, n2, n, 7, this.isOutParam);
                            }
                            break block74;
                        }
                        default: {
                            assert (false) : "Unexpected JDBCType: " + (Object)((Object)jDBCType);
                            break block74;
                        }
                    }
                }
                assert (JDBCType.TIME == jDBCType || JDBCType.DATE == jDBCType || JDBCType.TIMESTAMP == jDBCType) : "Unexpected JDBCType: " + (Object)((Object)jDBCType);
                this.tdsWriter.writeRPCDateTime(this.name, this.timestampNormalizedCalendar(gregorianCalendar, javaType, 1970), n, this.isOutParam);
            }
        }

        private GregorianCalendar timestampNormalizedCalendar(GregorianCalendar gregorianCalendar, JavaType javaType, int n) {
            if (null != gregorianCalendar) {
                switch (javaType) {
                    case DATE: 
                    case LOCALDATE: {
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        break;
                    }
                    case TIME: 
                    case LOCALTIME: 
                    case OFFSETTIME: {
                        assert (1970 == n || 1900 == n);
                        gregorianCalendar.set(n, 0, 1);
                        break;
                    }
                }
            }
            return gregorianCalendar;
        }

        private GregorianCalendar localCalendarAsUTC(GregorianCalendar gregorianCalendar) {
            if (null == gregorianCalendar) {
                return null;
            }
            int n = gregorianCalendar.get(1);
            int n2 = gregorianCalendar.get(2);
            int n3 = gregorianCalendar.get(5);
            int n4 = gregorianCalendar.get(11);
            int n5 = gregorianCalendar.get(12);
            int n6 = gregorianCalendar.get(13);
            int n7 = gregorianCalendar.get(14);
            gregorianCalendar.setTimeZone(UTC.timeZone);
            gregorianCalendar.set(n, n2, n3, n4, n5, n6);
            gregorianCalendar.set(14, n7);
            return gregorianCalendar;
        }

        @Override
        void execute(DTV dTV, Float f) throws SQLServerException {
            if (JDBCType.REAL == dTV.getJdbcType()) {
                this.tdsWriter.writeRPCReal(this.name, f, this.isOutParam);
            } else {
                Double d = null == f ? null : new Double(f.floatValue());
                this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
            }
        }

        @Override
        void execute(DTV dTV, Double d) throws SQLServerException {
            this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, BigDecimal bigDecimal) throws SQLServerException {
            if (DDC.exceedsMaxRPCDecimalPrecisionOrScale(bigDecimal)) {
                String string = bigDecimal.toString();
                this.tdsWriter.writeRPCStringUnicode(this.name, string, this.isOutParam, this.collation);
            } else {
                this.tdsWriter.writeRPCBigDecimal(this.name, bigDecimal, this.outScale, this.isOutParam);
            }
        }

        @Override
        void execute(DTV dTV, Long l) throws SQLServerException {
            this.tdsWriter.writeRPCLong(this.name, l, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, BigInteger bigInteger) throws SQLServerException {
            this.tdsWriter.writeRPCLong(this.name, bigInteger.longValue(), this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Short s) throws SQLServerException {
            this.tdsWriter.writeRPCShort(this.name, s, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Boolean bl) throws SQLServerException {
            this.tdsWriter.writeRPCBit(this.name, bl, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, byte[] byArray) throws SQLServerException {
            if (null != DTV.this.cryptoMeta) {
                this.tdsWriter.writeRPCNameValType(this.name, this.isOutParam, TDSType.BIGVARBINARY);
                if (null != byArray) {
                    byArray = SQLServerSecurityUtility.encryptWithKey(byArray, DTV.this.cryptoMeta, this.conn);
                    this.tdsWriter.writeEncryptedRPCByteArray(byArray);
                    this.writeEncryptData(dTV, false);
                } else {
                    this.tdsWriter.writeEncryptedRPCByteArray(byArray);
                    this.writeEncryptData(dTV, true);
                }
            } else {
                this.tdsWriter.writeRPCByteArray(this.name, byArray, this.isOutParam, dTV.getJdbcType(), this.collation);
            }
        }

        void writeEncryptData(DTV dTV, boolean bl) throws SQLServerException {
            JDBCType jDBCType = null == DTV.this.jdbcTypeSetByUser ? dTV.getJdbcType() : DTV.this.jdbcTypeSetByUser;
            switch (jDBCType.getIntValue()) {
                case 4: {
                    this.tdsWriter.writeByte(TDSType.INTN.byteValue());
                    this.tdsWriter.writeByte((byte)4);
                    break;
                }
                case -5: {
                    this.tdsWriter.writeByte(TDSType.INTN.byteValue());
                    this.tdsWriter.writeByte((byte)8);
                    break;
                }
                case -7: {
                    this.tdsWriter.writeByte(TDSType.BITN.byteValue());
                    this.tdsWriter.writeByte((byte)1);
                    break;
                }
                case 5: {
                    this.tdsWriter.writeByte(TDSType.INTN.byteValue());
                    this.tdsWriter.writeByte((byte)2);
                    break;
                }
                case -6: {
                    this.tdsWriter.writeByte(TDSType.INTN.byteValue());
                    this.tdsWriter.writeByte((byte)1);
                    break;
                }
                case 8: {
                    this.tdsWriter.writeByte(TDSType.FLOATN.byteValue());
                    this.tdsWriter.writeByte((byte)8);
                    break;
                }
                case 7: {
                    this.tdsWriter.writeByte(TDSType.FLOATN.byteValue());
                    this.tdsWriter.writeByte((byte)4);
                    break;
                }
                case -148: 
                case -146: 
                case 2: 
                case 3: {
                    if (JDBCType.MONEY == jDBCType || JDBCType.SMALLMONEY == jDBCType) {
                        this.tdsWriter.writeByte(TDSType.MONEYN.byteValue());
                        this.tdsWriter.writeByte((byte)(JDBCType.MONEY == jDBCType ? 8 : 4));
                        break;
                    }
                    this.tdsWriter.writeByte(TDSType.NUMERICN.byteValue());
                    if (bl) {
                        this.tdsWriter.writeByte((byte)17);
                        if (null != DTV.this.cryptoMeta && null != DTV.this.cryptoMeta.getBaseTypeInfo()) {
                            this.tdsWriter.writeByte((byte)(0 != DTV.this.valueLength ? DTV.this.valueLength : DTV.this.cryptoMeta.getBaseTypeInfo().getPrecision()));
                        } else {
                            this.tdsWriter.writeByte((byte)(0 != DTV.this.valueLength ? DTV.this.valueLength : 18));
                        }
                        this.tdsWriter.writeByte((byte)(0 != this.outScale ? this.outScale : 0));
                        break;
                    }
                    this.tdsWriter.writeByte((byte)17);
                    if (null != DTV.this.cryptoMeta && null != DTV.this.cryptoMeta.getBaseTypeInfo()) {
                        this.tdsWriter.writeByte((byte)DTV.this.cryptoMeta.getBaseTypeInfo().getPrecision());
                    } else {
                        this.tdsWriter.writeByte((byte)(0 != DTV.this.valueLength ? DTV.this.valueLength : 18));
                    }
                    if (null != DTV.this.cryptoMeta && null != DTV.this.cryptoMeta.getBaseTypeInfo()) {
                        this.tdsWriter.writeByte((byte)DTV.this.cryptoMeta.getBaseTypeInfo().getScale());
                        break;
                    }
                    this.tdsWriter.writeByte((byte)(null != dTV.getScale() ? dTV.getScale() : 0));
                    break;
                }
                case -145: {
                    this.tdsWriter.writeByte(TDSType.GUID.byteValue());
                    if (bl) {
                        this.tdsWriter.writeByte((byte)(0 != DTV.this.valueLength ? DTV.this.valueLength : 1));
                        break;
                    }
                    this.tdsWriter.writeByte((byte)16);
                    break;
                }
                case 1: {
                    this.tdsWriter.writeByte(TDSType.BIGCHAR.byteValue());
                    if (bl) {
                        this.tdsWriter.writeShort((short)(0 != DTV.this.valueLength ? DTV.this.valueLength : 1));
                    } else {
                        this.tdsWriter.writeShort((short)DTV.this.valueLength);
                    }
                    if (null != this.collation) {
                        this.collation.writeCollation(this.tdsWriter);
                        break;
                    }
                    this.conn.getDatabaseCollation().writeCollation(this.tdsWriter);
                    break;
                }
                case -15: {
                    this.tdsWriter.writeByte(TDSType.NCHAR.byteValue());
                    if (bl) {
                        this.tdsWriter.writeShort((short)(0 != DTV.this.valueLength ? DTV.this.valueLength * 2 : 1));
                    } else if (this.isOutParam) {
                        this.tdsWriter.writeShort((short)(DTV.this.valueLength * 2));
                    } else {
                        this.tdsWriter.writeShort((short)DTV.this.valueLength);
                    }
                    if (null != this.collation) {
                        this.collation.writeCollation(this.tdsWriter);
                        break;
                    }
                    this.conn.getDatabaseCollation().writeCollation(this.tdsWriter);
                    break;
                }
                case -1: 
                case 12: {
                    this.tdsWriter.writeByte(TDSType.BIGVARCHAR.byteValue());
                    if (bl) {
                        if (dTV.jdbcTypeSetByUser.getIntValue() == -1) {
                            this.tdsWriter.writeShort((short)-1);
                        } else {
                            this.tdsWriter.writeShort((short)(0 != DTV.this.valueLength ? DTV.this.valueLength : 1));
                        }
                    } else if (dTV.getJdbcType().getIntValue() == -1 || dTV.getJdbcType().getIntValue() == -16) {
                        this.tdsWriter.writeShort((short)1);
                    } else if (dTV.jdbcTypeSetByUser.getIntValue() == -1) {
                        this.tdsWriter.writeShort((short)-1);
                    } else {
                        this.tdsWriter.writeShort((short)DTV.this.valueLength);
                    }
                    if (null != this.collation) {
                        this.collation.writeCollation(this.tdsWriter);
                        break;
                    }
                    this.conn.getDatabaseCollation().writeCollation(this.tdsWriter);
                    break;
                }
                case -16: 
                case -9: {
                    this.tdsWriter.writeByte(TDSType.NVARCHAR.byteValue());
                    if (bl) {
                        if (dTV.jdbcTypeSetByUser.getIntValue() == -16) {
                            this.tdsWriter.writeShort((short)-1);
                        } else {
                            this.tdsWriter.writeShort((short)(0 != DTV.this.valueLength ? DTV.this.valueLength * 2 : 1));
                        }
                    } else if (this.isOutParam) {
                        if (dTV.jdbcTypeSetByUser.getIntValue() == -16) {
                            this.tdsWriter.writeShort((short)-1);
                        } else {
                            this.tdsWriter.writeShort((short)(DTV.this.valueLength * 2));
                        }
                    } else {
                        this.tdsWriter.writeShort((short)DTV.this.valueLength);
                    }
                    if (null != this.collation) {
                        this.collation.writeCollation(this.tdsWriter);
                        break;
                    }
                    this.conn.getDatabaseCollation().writeCollation(this.tdsWriter);
                    break;
                }
                case -2: {
                    this.tdsWriter.writeByte(TDSType.BIGBINARY.byteValue());
                    if (bl) {
                        this.tdsWriter.writeShort((short)(0 != DTV.this.valueLength ? DTV.this.valueLength : 1));
                        break;
                    }
                    this.tdsWriter.writeShort((short)DTV.this.valueLength);
                    break;
                }
                case -4: 
                case -3: {
                    this.tdsWriter.writeByte(TDSType.BIGVARBINARY.byteValue());
                    if (bl) {
                        if (dTV.jdbcTypeSetByUser.getIntValue() == -4) {
                            this.tdsWriter.writeShort((short)-1);
                            break;
                        }
                        this.tdsWriter.writeShort((short)(0 != DTV.this.valueLength ? DTV.this.valueLength : 1));
                        break;
                    }
                    if (dTV.jdbcTypeSetByUser.getIntValue() == -4) {
                        this.tdsWriter.writeShort((short)-1);
                        break;
                    }
                    this.tdsWriter.writeShort((short)DTV.this.valueLength);
                    break;
                }
                default: {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnsupportedDataTypeAE"));
                    throw new SQLServerException(messageFormat.format(new Object[]{jDBCType}), null, 0, null);
                }
            }
            this.tdsWriter.writeCryptoMetaData();
        }

        @Override
        void execute(DTV dTV, Blob blob) throws SQLServerException {
            assert (null != blob);
            long l = 0L;
            InputStream inputStream = null;
            try {
                l = DataTypes.getCheckedLength(this.conn, dTV.getJdbcType(), blob.length(), false);
                inputStream = blob.getBinaryStream();
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.conn, null, sQLException.getMessage(), null, false);
            }
            if (null == inputStream) {
                this.tdsWriter.writeRPCByteArray(this.name, null, this.isOutParam, dTV.getJdbcType(), this.collation);
            } else {
                this.tdsWriter.writeRPCInputStream(this.name, inputStream, l, this.isOutParam, dTV.getJdbcType(), this.collation);
            }
        }

        @Override
        void execute(DTV dTV, SQLServerSQLXML sQLServerSQLXML) throws SQLServerException {
            InputStream inputStream = null == sQLServerSQLXML ? null : sQLServerSQLXML.getValue();
            this.tdsWriter.writeRPCXML(this.name, inputStream, null == inputStream ? 0L : dTV.getStreamSetterArgs().getLength(), this.isOutParam);
        }

        @Override
        void execute(DTV dTV, InputStream inputStream) throws SQLServerException {
            this.tdsWriter.writeRPCInputStream(this.name, inputStream, null == inputStream ? 0L : dTV.getStreamSetterArgs().getLength(), this.isOutParam, dTV.getJdbcType(), this.collation);
        }

        @Override
        void execute(DTV dTV, Reader reader) throws SQLServerException {
            JDBCType jDBCType = dTV.getJdbcType();
            assert (null != reader);
            assert (JDBCType.NCHAR == jDBCType || JDBCType.NVARCHAR == jDBCType || JDBCType.LONGNVARCHAR == jDBCType || JDBCType.NCLOB == jDBCType) : "SendByRPCOp(Reader): Unexpected JDBC type " + (Object)((Object)jDBCType);
            this.tdsWriter.writeRPCReaderUnicode(this.name, reader, dTV.getStreamSetterArgs().getLength(), this.isOutParam, this.collation);
        }
    }
}

